/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.XmlException;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.TestPartner;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=TestPartner.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class TestPartnerImpl extends SCAComponentImpl implements TestPartner {
	private Logger log = Logger.getLogger(TestPartnerImpl.class.getName());

	private Service service;
	
	/**
	 * Default constructor
	 * @throws CoreException
	 */
	public TestPartnerImpl()  {
		super();
	}


	public Message accept(Message msg, String invokedOperation) throws CoreException {
		return this.service.execute(msg, invokedOperation);
	}
	
	public ExecutionEnvironmentTest getExecutionEnvironmentTest() throws CoreException {
		ExecutionEnvironmentTest res = null;
		try {
			Component execEnvComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
			res = (ExecutionEnvironmentTest) execEnvComp.getFcInterface("service");
		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public Service getMockService() {
		return this.service;
	}

	public void setMockService(Service s) {
		this.service = s;
	}
	
	public void setLog(Logger logger) {
		this.log = logger;
	}


    @Override
    public Element getValue(Execution execution) {
        throw new UnsupportedOperationException();
    }


    @Override
    public void initialize(Execution execution) {
        throw new UnsupportedOperationException();
    }


    @Override
    public void assign(Execution execution, Object value) {
        throw new UnsupportedOperationException();
    }


    @Override
    public void setDocumentation(Documentation doc) {
        // TODO Auto-generated method stub
        
    }


    @Override
    public Documentation getDocumentation() {
        throw new UnsupportedOperationException();
    }


    @Override
    public Documentation createDocumentation() {
        throw new UnsupportedOperationException();
    }


    @Override
    public Map<QName, String> getOtherAttributes() throws XmlException {
        throw new UnsupportedOperationException();
    }

	
	
}

