/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.env;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractSenderImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.TestExternalContextImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.TestPartner;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

@Scope(value="COMPOSITE")
@Service(value={Sender.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class TestSenderImpl
extends AbstractSenderImpl
implements Sender {
    private static Logger log = Logger.getLogger(TestSenderImpl.class.getName());
    private static int internalClientCpt = 1;

    public ExecutionEnvironmentTest getExecutionEnvironmentTest() throws CoreException {
        ExecutionEnvironmentTest res = null;
        try {
            Component externalEnvComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            Component core = SCAHelper.getSCAHelper().getParent(externalEnvComp);
            Component executionEnvironment = SCAHelper.getSCAHelper().getParent(core);
            res = (ExecutionEnvironmentTest)executionEnvironment.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void sendTo(Message message, String address, Map<Partner, Map<String, ExternalContext>> context, boolean isReply) throws CoreException {
        String endpointName = message.getEndpoint();
        QName serviceName = message.getService();
        String operationName = message.getOperationName();
        if (message == null) {
            throw new CoreException("ASynchronous send: Message send to " + endpointName + " on operation " + operationName + " cannot be null. You must assign the variable associated to this message");
        }
        System.out.println("MESSAGE SENDED BY CORE to provider " + endpointName + ": \n" + message);
        if (endpointName == null) {
            throw new CoreException("the provider endpoint name cannot be null");
        }
        System.out.println("context : " + context);
        System.out.println("provider serviceName : " + serviceName);
        System.out.println("provider endpointName : " + endpointName);
        System.out.println("provider opertation" + operationName);
        ProcessKeyImpl pk = new ProcessKeyImpl(null, serviceName, endpointName);
        List processes = this.getExternalEnvironment().getEngine().getProcessInstanceRegistry().getProcessInstances((ProcessKey)pk);
        if (processes.size() > 0) {
            this.findAndSendResponseToClient(message, context);
        } else {
            this.findAndExecuteProvider(message, endpointName);
        }
    }

    public Message sendSyncTo(Message message, String address, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        String endpointName = message.getEndpoint();
        QName serviceName = message.getService();
        String operationName = message.getOperationName();
        if (message == null) {
            throw new CoreException("Synchronous send: Message send to " + endpointName + " on operation " + operationName + " cannot be null. You must assign the variable associated to this message");
        }
        System.out.println("RRRRRRRRRRRRRRR message.getQName() = " + message.getQName());
        System.out.println("MESSAGE SENDED SYNC BY CORE to provider " + endpointName + ": \n" + message);
        System.out.println("********* providerEndpoint.getEndpointName() = " + endpointName);
        System.out.println("********* providerEndpoint.getServiceName() = " + serviceName);
        Message responseMessage = this.findAndExecuteProvider(message, address);
        return responseMessage;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Message findAndExecuteProvider(Message message, String address) throws CoreException {
        Message responseIfExist = null;
        String endpointName = message.getEndpoint();
        QName interfaceName = message.getInterface();
        QName serviceName = message.getService();
        String operationName = message.getOperationName();
        TestPartner provider = null;
        System.out.println("providerEndpoint.getEndpointName() = " + endpointName);
        System.out.println("providerEndpoint.getAddress() = " + address);
        System.out.println("this.getExecutionEnvironmentTest().getTestPartners().size() = " + this.getExecutionEnvironmentTest().getTestPartners().size());
        System.out.println("this.getExecutionEnvironmentTest().getTestPartners() = " + this.getExecutionEnvironmentTest().getTestPartners());
        for (TestPartner providerItem : this.getExecutionEnvironmentTest().getTestPartners()) {
            System.out.println("************** providerItem = " + providerItem.getName());
            if (endpointName == null || !endpointName.equals(providerItem.getName())) continue;
            provider = providerItem;
            break;
        }
        if (provider == null && address != null) {
            for (TestPartner providerItem : this.getExecutionEnvironmentTest().getTestPartners()) {
                System.out.println("************** providerItem = " + providerItem.getName());
                if (address == null || !address.endsWith(providerItem.getName())) continue;
                provider = providerItem;
                break;
            }
        }
        if (provider == null && interfaceName != null) {
            for (TestPartner providerItem : this.getExecutionEnvironmentTest().getTestPartners()) {
                System.out.println("************** providerItem = " + providerItem.getName());
                if (interfaceName == null || !interfaceName.equals(providerItem.getMockService().getInterfaceName())) continue;
                provider = providerItem;
                break;
            }
        }
        System.out.println("PROCESS DEFINITION provider == " + provider);
        ProcessDefinition processDefinition = null;
        if (provider != null) {
            responseIfExist = provider.accept(message, operationName);
            if (responseIfExist == null) return responseIfExist;
            System.out.println("MESSAGE RECEIVED BY CORE from " + endpointName + " : \n" + responseIfExist);
            return responseIfExist;
        }
        ProcessKeyImpl key = new ProcessKeyImpl(interfaceName, serviceName, endpointName);
        processDefinition = this.getExecutionEnvironmentTest().getCore().getModel().getRegistry().getProcessDefinition((ProcessKey)key);
        System.out.println("processDefinition1 == " + processDefinition);
        if (processDefinition == null) {
            key = new ProcessKeyImpl(interfaceName, serviceName, address);
            processDefinition = this.getExecutionEnvironmentTest().getCore().getModel().getRegistry().getProcessDefinition((ProcessKey)key);
        }
        System.out.println("processDefinition2 == " + processDefinition);
        if (processDefinition != null) {
            message.setEndpoint(endpointName);
            message.setService(serviceName);
            System.out.println("RRRRRRRRRRRRRRRRRRR externalMessage.getQName() = " + message.getQName());
            ClientEndpoint internalClient = this.getExecutionEnvironmentTest().createClientEndpoint("internalClient" + internalClientCpt);
            ++internalClientCpt;
            log.finest("Internal client created:  " + internalClient.getName());
            System.out.println("Internal client created:  " + internalClient.getName());
            responseIfExist = internalClient.sendSync(message);
            System.out.println("MESSAGE RECEIVED BY CORE from " + internalClient.getName() + " : \n" + responseIfExist);
            log.finest("MESSAGE RECEIVED BY CORE from " + internalClient.getName() + " : \n" + responseIfExist);
            System.out.println("avant supression");
            this.getExecutionEnvironmentTest().getClientEndpoints().remove(internalClient);
            System.out.println("apres supression");
            return responseIfExist;
        }
        log.severe("Impossible to find provider corresponding to this message: " + message);
        throw new CoreException("Impossible to find provider corresponding to this message: " + message);
    }

    private void findAndSendResponseToClient(Message externalMessage, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        System.out.println("In test context : " + context);
        String clientName = ((TestExternalContextImpl)ProcessImpl.getFirstExternalContext(context)).getClientEndpointName();
        System.out.println("Client to send response: " + clientName);
        for (ClientEndpoint clientItem : this.getExecutionEnvironmentTest().getClientEndpoints()) {
            String name = clientItem.getName();
            if (!clientName.equalsIgnoreCase(name)) continue;
            clientItem.setResponse(externalMessage);
            break;
        }
    }

    private void findAndSendExceptionToClient(CoreException e, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        String clientName = ((TestExternalContextImpl)ProcessImpl.getFirstExternalContext(context)).getClientEndpointName();
        for (ClientEndpoint clientItem : this.getExecutionEnvironmentTest().getClientEndpoints()) {
            String name = clientItem.getName();
            if (!clientName.equalsIgnoreCase(name)) continue;
            clientItem.setException(e);
            break;
        }
    }

    public void sendTo(CoreException e, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        this.findAndSendExceptionToClient(e, context);
    }
}

