/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.util;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.env.impl.OperationImpl;
import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class MockServiceBuilder {
    public static Operation buildOperation(String operationName, Service service, File requestXmlFile, QName requestMessageName, File responseXmlFile, QName responseMessageName, File faultXmlFile, QName faultMessageName) throws CoreException {
        OperationImpl operation = new OperationImpl(operationName, responseXmlFile == null ? "in-only" : "in-out", service);
        Message in = MockServiceBuilder.buildMessage(service.getName(), service.getTestPartner().getName(), requestXmlFile, requestMessageName, operationName);
        Message out = null;
        if (responseXmlFile != null) {
            out = MockServiceBuilder.buildMessage(service.getName(), service.getTestPartner().getName(), responseXmlFile, responseMessageName, operationName);
        }
        Message fault = null;
        if (faultXmlFile != null) {
            fault = MockServiceBuilder.buildMessage(service.getName(), service.getTestPartner().getName(), faultXmlFile, faultMessageName, operationName);
        }
        operation.addMessageExchangeInstances(in, out, fault);
        return operation;
    }

    public static void addMessageExchangeInstances2Operation(Operation op, File requestXmlFile, QName requestMessageName, File responseXmlFile, QName responseMessageName, File faultXmlFile, QName faultMessageName) throws CoreException {
        Message in = MockServiceBuilder.buildMessage(op.getService().getName(), op.getService().getTestPartner().getName(), requestXmlFile, requestMessageName, op.getName());
        Message out = null;
        if (responseXmlFile != null) {
            out = MockServiceBuilder.buildMessage(op.getService().getName(), op.getService().getTestPartner().getName(), responseXmlFile, responseMessageName, op.getName());
        }
        Message fault = null;
        if (faultXmlFile != null) {
            fault = MockServiceBuilder.buildMessage(op.getService().getName(), op.getService().getTestPartner().getName(), faultXmlFile, faultMessageName, op.getName());
        }
        op.addMessageExchangeInstances(in, out, fault);
    }

    public static Message buildMessage(QName serviceName, String endpointName, File xmlFile, QName messageName, String operationName) throws CoreException {
        MessageImpl msg = new MessageImpl(operationName);
        msg.setService(serviceName);
        msg.setEndpoint(endpointName);
        try {
            msg.getBody().setPayload(MockServiceBuilder.buildContent(xmlFile));
        }
        catch (JDOMException e) {
            throw new CoreException((Throwable)e);
        }
        catch (IOException e) {
            throw new CoreException((Throwable)e);
        }
        return msg;
    }

    public static Element buildContent(File xmlFile) throws JDOMException, IOException {
        SAXBuilder parser = new SAXBuilder();
        Element res = null;
        if (xmlFile != null && xmlFile.exists()) {
            Document doc = parser.build(xmlFile);
            res = doc.getRootElement();
        }
        return res;
    }
}

