/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.env.api;

import java.util.List;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface ExecutionEnvironmentTest extends SCAComponent {

	Core getCore();
	
	void setCore(Core core) throws CoreException;
	
	ClientEndpoint createClientEndpoint(String name) throws CoreException;
	
	TestPartner createTestPartner(String name, Class<? extends Service> serviceClass) throws CoreException;
	
	TestPartner createTestPartner(String name, Class<? extends Service> serviceClass, List<org.jdom.Element> payload) throws CoreException;
	
	void addClientEndpoint(ClientEndpoint cep) throws CoreException;
	
	List<ClientEndpoint> getClientEndpoints();
	
	void addTestPartner(TestPartner pep) throws CoreException;
	
	List<TestPartner> getTestPartners();
}
