/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
//@Scope("COMPOSITE")
//@Service(value=AbstractCompiler.class,names="service")
//@PolicySets("frascati:scaEasyPrimitive")
public class TestRegistry extends AbstractProcessDefinitionRegistry<ProcessDefinition>{

	@Override
	public ProcessDefinition getProcessDefinition(ProcessKey name) {
		return this.registry.get(name);
	}

	
	
	@Override
	public List<ProcessDefinition> getAllProcessDefinitions() {
		  return new ArrayList<ProcessDefinition>((Collection<ProcessDefinition>) this.registry.values());
	}

	@Override
	public ProcessDefinition removeProcessDefinition(ProcessKey name,
			boolean forceUninstall) throws CoreException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <D extends ProcessDefinition> boolean isCreateInstance(D def,
			Message mess) throws CoreException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public List<ProcessKey> createKeys(ProcessDefinition processDefinition){
	  final List<ProcessKey> keys = new ArrayList<ProcessKey>();
	  	ProcessKey pk = new ProcessKeyImpl();
		pk.setInterface(processDefinition.getQName());
		pk.setService(processDefinition.getQName());
		pk.setEndpoint(processDefinition.getQName().getLocalPart());
	  
		keys.add(pk);
		
		this.registry.put(pk, processDefinition);
		
	  return keys;
	}

	@Override
	public synchronized ProcessDefinition storeProcessDefinition(URI uri,
			ProcessContextDefinition context) throws CoreException {
		ProcessKey key = new ProcessKeyImpl();
		TestProcessDefinition def = null;
		try {
			def = new TestProcessDefinition(QName.valueOf(URLDecoder.decode(uri.toString(), "UTF-8")));
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		this.registry.put(key, def);
		
		return def;
	}
	
}
