/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.TestPartner;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public abstract class AbstractServiceImpl implements Service {

	private static Logger log = Logger.getLogger(AbstractServiceImpl.class.getName());

    private QName name;

    private QName interfaceName;

	private TestPartner providerEndpoint;

	private List<Operation> operations = new ArrayList<Operation>();

	public AbstractServiceImpl(TestPartner providerEndpoint) {
		this.providerEndpoint = providerEndpoint;
	}

	public QName getName() {
		return this.name;
	}

	public void setName(QName name) {
		this.name = name;
	}

	public void addOperation(Operation op) {
		this.operations.add(op);
	}

	public List<Operation> getOperations() {
		return this.operations;
	}

	public synchronized Message execute(Message msg, String invokedOperation) throws CoreException {
		Message res = null;

		// found the operation
		Operation foundOperation = null;

		
		for (Operation operation: this.operations) {
		
			if(invokedOperation.equals(operation.getName())) {
				foundOperation = operation;
			}
		}

		// execute the operation
		if(foundOperation == null) {
			log.severe("operation " + invokedOperation + " with message " + msg.getBody().getPayload() + " not found on service " + this.getName());
			throw new RuntimeException("operation " + invokedOperation + " with message:\n " + msg + "\n not found on service " + this.getName());
		} else {
			log.finest("Execution of operation " + foundOperation.getName() + " on service " + this.getName());
			res = foundOperation.execute(msg);
		}
		return res;
	}

	public TestPartner getTestPartner() {
		return this.providerEndpoint;
	}

	public void setTestPartner(TestPartner pep) {
		this.providerEndpoint = pep;
	}
	
	@Override
	public QName getInterfaceName() {
	    return interfaceName;
	}
	
	@Override
	public void setInterfaceName(QName interfaceName) {
	    this.interfaceName = interfaceName;
	}
}
