/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.env.api.TestPartner;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ExecutionEnvironmentTest.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ExecutionEnvironmentTestImpl extends SCAComponentImpl implements ExecutionEnvironmentTest {

	private Logger log = Logger.getLogger(ExecutionEnvironmentTestImpl.class.getName());

	private Core core;

	private List<ClientEndpoint> clientEndpoints = new ArrayList<ClientEndpoint>();
	private List<TestPartner> providerEndpoints = new ArrayList<TestPartner>();

	/**
	 * Default constructor
	 * @throws CoreException
	 */
	public ExecutionEnvironmentTestImpl()  {
		super();
	}

	@Override
	public void addClientEndpoint(ClientEndpoint cep) throws CoreException {
		try {
			SCAHelper.getSCAHelper().addComponent(cep.getComponent(), this.getComponent(), null);
			this.clientEndpoints.add(cep);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
	}

    @Override
	public void addTestPartner(TestPartner pep) throws CoreException {
		try {
			SCAHelper.getSCAHelper().addComponent(pep.getComponent(), this.getComponent(), null);
			this.providerEndpoints.add(pep);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
	}

    @Override
	public Core getCore() {
		return this.core;
	}

    @Override
    public void setCore(Core core) throws CoreException {
        try {
            SCAHelper.getSCAHelper().addComponent(core.getComponent(), this.getComponent(), null);
            this.core = core;
        } catch (SCAException e) {
            throw new CoreException(e);
        }
    }

    @Override
	public ClientEndpoint createClientEndpoint(String name)
	throws CoreException {
		ClientEndpoint clientEndpoint = null;
		Component fractalClientEndpoint = null;
		try {
			//		create a new client endpoint
			fractalClientEndpoint = SCAHelper.getSCAHelper().createNewComponent(ClientEndpointImpl.class.getName(), null);
			SCAHelper.getSCAHelper().addComponent(fractalClientEndpoint, this.getComponent(), null);
			clientEndpoint = (ClientEndpoint)((SCAContentController)fractalClientEndpoint.getFcInterface("/sca-content-controller")).getFcContent();
			//fractalClientEndpoint.getFcInterface("/content");
			SCAHelper.getSCAHelper().startComponent(fractalClientEndpoint);

			//((ClientEndpointImpl)clientEndpoint).init(fractalClientEndpoint);
			((ClientEndpointImpl)clientEndpoint).setName(name);
			((ClientEndpointImpl)clientEndpoint).init();

			clientEndpoint = (ClientEndpoint) ((SCAContentController)fractalClientEndpoint.getFcInterface("/sca-content-controller")). getFcContent(); 
			//fractalClientEndpoint.getFcInterface("service");
			log.fine("Creation of the fractal client endpoint: " + name);
			this.clientEndpoints.add(clientEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return clientEndpoint;
	}


    @Override
    public TestPartner createTestPartner(String name, Class<? extends Service> serviceClass)
	throws CoreException {
		TestPartner providerEndpoint = null;
		Component fractalTestPartner = null;
		try {
			// create a new provider endpoint
			fractalTestPartner = SCAHelper.getSCAHelper().createNewComponent(TestPartnerImpl.class.getName(), null);
			SCAHelper.getSCAHelper().addComponent(fractalTestPartner, this.getComponent(), null);
			providerEndpoint = (TestPartner) ((SCAContentController)fractalTestPartner.getFcInterface("/sca-content-controller")).getFcContent();
			//fractalTestPartner.getFcInterface("/content");
			SCAHelper.getSCAHelper().startComponent(fractalTestPartner);

			//			((TestPartnerImpl)providerEndpoint).init(fractalTestPartner);
			((TestPartnerImpl)providerEndpoint).setName(name);

			//providerEndpoint = (TestPartner) fractalTestPartner.getFcInterface("service");

			Constructor<? extends Service> constructor = (Constructor<? extends Service>) serviceClass.getConstructors()[0];
			Service service = constructor.newInstance(providerEndpoint);

			providerEndpoint.setMockService(service);
			service.setTestPartner(providerEndpoint);

			log.fine("Creation of the fractal provider endpoint: " + name);
			this.providerEndpoints.add(providerEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (InstantiationException e) {
			throw new CoreException(e);
		} catch (IllegalAccessException e) {
			throw new CoreException(e);
		} catch (InvocationTargetException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return providerEndpoint;
	}


    @Override
	public TestPartner createTestPartner(String name, Class<? extends Service> serviceClass,
			List<org.jdom.Element> payloads)
	throws CoreException {
		TestPartner providerEndpoint = null;
		Component fractalTestPartner = null;
		try {
			// create a new provider endpoint
			fractalTestPartner = SCAHelper.getSCAHelper().createNewComponent(TestPartnerImpl.class.getName(), null);
			SCAHelper.getSCAHelper().addComponent(fractalTestPartner, this.getComponent(), null);
			providerEndpoint = (TestPartner) ((SCAContentController)fractalTestPartner.getFcInterface("/sca-content-controller")).getFcContent();
			//fractalTestPartner.getFcInterface("/content");
			SCAHelper.getSCAHelper().startComponent(fractalTestPartner);

			//((TestPartnerImpl)providerEndpoint).init(fractalTestPartner);
			((TestPartnerImpl)providerEndpoint).setName(name);

			//providerEndpoint = (TestPartner) fractalTestPartner.getFcInterface("service");

			Constructor<? extends Service> constructor = (Constructor<? extends Service>) serviceClass.getConstructors()[0];
			Service service = constructor.newInstance(providerEndpoint, payloads);

			providerEndpoint.setMockService(service);
			service.setTestPartner(providerEndpoint);


			log.fine("Creation of the fractal provider endpoint: " + name);
			this.providerEndpoints.add(providerEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (InstantiationException e) {
			throw new CoreException(e);
		} catch (IllegalAccessException e) {
			throw new CoreException(e);
		} catch (InvocationTargetException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return providerEndpoint;
	}


    @Override
	public List<ClientEndpoint> getClientEndpoints() {
		return this.clientEndpoints;
	}

    @Override
	public List<TestPartner> getTestPartners() {
		return this.providerEndpoints;
	}

	public void setLog(Logger logger) {
		this.log = logger;
	}
}
