/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import junit.framework.Assert;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class OperationImpl implements Operation {

    private static Logger log = Logger.getLogger(OperationImpl.class.getName());

    private String name;

    private String pattern;

    private List<MessageExchangeInstances> meis = new ArrayList<MessageExchangeInstances>();

    private int successfulInvocation = 0;

    private int invocationNumber = 0;

    private Service service;

    public OperationImpl() {

    }

    public OperationImpl(String name, String pattern, Service service) {
        this.name = name;
        this.pattern = pattern;
        this.service = service;
    }

    public synchronized Message execute(Message msg)
            throws CoreException {
        
        System.err.println("+++++++++++++++++++++++++++++++++++++++***********************");
        
        Message res = null;
        MessageExchangeInstances mei = null;
        this.invocationNumber++;

        String actual = null;
        String expected = null;
        log.finest("actual msg BEFORE : \n" + msg.toString());
        if (msg.getBody().getPayload() != null) {
            actual = msg.toString();
        }

        log.finest("actual msg:\n" + actual);
        for (MessageExchangeInstances meiItem : this.meis) {

            expected = null;
            if (meiItem.getIn().getBody().getPayload() != null) {
                expected = meiItem.getIn().toString();
            }
            log.finest("expected msg:\n" + expected);

            if (actual == null && expected == null) {
                log.finest("Expected message is null ...");
                mei = meiItem;
                break;
            } else {
                log.finest("Comparison of the expected message and the actual one.");
                InputStream actualStream = new ByteArrayInputStream(
                        actual.getBytes());
                InputStream expectedStream = new ByteArrayInputStream(
                        expected.getBytes());
                try {
                    if (XMLComparator.isEquivalent(expectedStream,
                            actualStream)) {
                        mei = meiItem;
                        break;
                    }
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        
        

        if (mei == null) {
            Assert.fail("no input message corresponding to " + actual
                    + " in operation " + this.getName());
        }
        
        // set current exchange at the end of list
        this.meis.remove(mei);
        this.meis.add(mei);

        if (mei.getOut() != null) {
            res = mei.getOut();
        } else if (mei.getFault() != null) {
            CoreException ex = new CoreException();
            ex.setFault(mei.getFault());
            System.out.println("Send Message fault by partner:\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(mei.getFault().getBody().getPayload()));
            throw ex;
        }

        this.successfulInvocation++;
        return res;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public List<MessageExchangeInstances> getMessageExchangeInstances() {
        return this.meis;
    }

    public void setMessageExchangeInstances(List<MessageExchangeInstances> mei) {
        this.meis = mei;
    }

    public void addMessageExchangeInstances(Message in,
            Message out, Message fault) {
        this.meis.add(new MessageExchangeInstancesImpl(in, out, fault));
    }

    public class MessageExchangeInstancesImpl implements
            Operation.MessageExchangeInstances {

        public Message in;

        public Message out;

        public Message fault;

        public MessageExchangeInstancesImpl(Message in,
                Message out, Message fault) {
            this.in = in;
            this.out = out;
            this.fault = fault;
        }

        public Message getFault() {
            return this.fault;
        }

        public Message getIn() {
            return this.in;
        }

        public Message getOut() {
            return this.out;
        }

        public void setFault(Message msg) {
            this.fault = msg;
        }

        public void setIn(Message msg) {
            this.in = msg;
        }

        public void setOut(Message msg) {
            this.out = msg;
        }

    }

    public int getSuccessfulInvocation() {
        return this.successfulInvocation;
    }

    public int getInvocationNumber() {
        return invocationNumber;
    }

    public void clean() {
        successfulInvocation = 0;
        invocationNumber = 0;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

	@Override
	public String toString() {
		return "OperationImpl [name=" + name + "]";
	}


    
    
}
