/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api;

import java.util.HashMap;
import java.util.Map;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractSimpleBehaviourImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=ExtendedBehaviour.class,names="extended_behavior_service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class AbstractExtendedBehaviourImpl extends AbstractSimpleBehaviourImpl implements ExtendedBehaviour {

	private ClassLoader classloader;
	protected Map<String, Object> context = new HashMap<String, Object>();
	
	
	/**
	 * Constructor.
	 */
	public AbstractExtendedBehaviourImpl() {
		// nothing
	}

	public ClassLoader getClassLoader() {
		return this.classloader;
	}


	public void setClassLoader(ClassLoader classloader) {
		this.classloader = classloader;
	}
}
