/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.StringExpression;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.LoggerBehaviour;


@Scope("COMPOSITE")
@Service(value=LoggerBehaviour.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class LoggerBehaviourImpl extends EchoBehaviourImpl implements LoggerBehaviour {


	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(LoggerBehaviourImpl.class
			.getName());


	@Property(name="level", required=true)
	private LEVEL level;


	public LoggerBehaviourImpl(){
		
	}

	public LEVEL getLevel() {
		return this.level;
	}


	public void setLevel(LEVEL level) {
		this.level = level;

	}

	public void severe(String msg) {
		this.log.severe("[BPEL] "+Calendar.getInstance().getTime().toString()+" "+msg);

	}

	public void warning(String msg) {
		this.log.warning("[BPEL]  "+Calendar.getInstance().getTime().toString()+" "+msg);

	}

	public void info(String msg) {
		this.log.info("[BPEL] "+Calendar.getInstance().getTime().toString()+" "+msg);

	}

	public void debug(String msg) {
		this.log.info("[BPEL] "+Calendar.getInstance().getTime().toString()+" "+msg);

	}


	@Override
	public String toString() {
		return "LoggerActivity";
	}

	
	@Override
	protected void executeOnInactive() throws CoreException {
		String msg = this.getMessage().evaluate(this.node.getExecution().getParentScope());
		
		if(this.level == null){
			severe("Level is null !" + msg);
		}else 
		 if(this.level.equals(LoggerBehaviour.LEVEL.SEVERE)){
			severe(msg);
		}else if(this.level.equals(LoggerBehaviour.LEVEL.WARNING)){
			warning(msg);
		}else if(this.level.equals(LoggerBehaviour.LEVEL.INFO)){
			info(msg);
		}else if(this.level.equals(LoggerBehaviour.LEVEL.DEBUG)){
			debug(msg);
		}
	}	

}
