/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import java.util.Calendar;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.LoggerBehaviour;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value = LoggerBehaviour.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class LoggerBehaviourImpl extends EchoBehaviourImpl implements
		LoggerBehaviour {

	private Logger log = Logger.getLogger(LoggerBehaviourImpl.class.getName());

	@Property(name = "level", required = true)
	private LEVEL level;

	public LoggerBehaviourImpl() {

	}

	public LEVEL getLevel() {
		return this.level;
	}

	public void setLevel(LEVEL level) {
		this.level = level;

	}

	public void severe(String msg) {
		this.log.severe("[BPEL] " + Calendar.getInstance().getTime().toString()
				+ " " + msg);

	}

	public void warning(String msg) {
		this.log.warning("[BPEL]  "
				+ Calendar.getInstance().getTime().toString() + " " + msg);

	}

	public void info(String msg) {
		this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString()
				+ " " + msg);

	}

	public void debug(String msg) {
		this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString()
				+ " " + msg);

	}


    @Override
    protected void doExecute(Execution execution) {
        String msg = getNode().getScope()
				.getExpressionEvaluator().evaluateAsString(execution, getMessage());

		if (this.level == null) {
			severe("Level is null !" + msg);
		} else if (this.level.equals(LoggerBehaviour.LEVEL.SEVERE)) {
			severe(msg);
		} else if (this.level.equals(LoggerBehaviour.LEVEL.WARNING)) {
			warning(msg);
		} else if (this.level.equals(LoggerBehaviour.LEVEL.INFO)) {
			info(msg);
		} else if (this.level.equals(LoggerBehaviour.LEVEL.DEBUG)) {
			debug(msg);
		}
	}

}
