/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.util;

import java.util.List;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.DebugBehaviour;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public final class DebugUtil {

	public static DebugBehaviour findDebugBehaviour(Scope process) throws CoreException {
		DebugBehaviour res = null;
		List<DebugBehaviour> debugs = process.findBehaviours(DebugBehaviour.class);
		if(debugs.size() > 1) {
			throw new CoreException("Impossible to have severals DebugBehaviour on several nodes.");
		}
		if(debugs.size() == 1) {
			res = debugs.get(0);
		}
		return res;
	}

	
}
