/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.ExtendedBehaviour;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface LoggerBehaviour extends ExtendedBehaviour, EchoBehaviour {

	enum LEVEL{SEVERE, WARNING, INFO, DEBUG};
	
	QName name = new QName(ExtendedBehaviour.name.getNamespaceURI(), "Logger");

	LEVEL getLevel();

	void setLevel(LEVEL level);

	void severe(String msg);
	
	void warning(String msg);
	
	void info(String msg);
	
	void debug(String msg);
}
