/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.LoggerBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl.EchoBehaviourImpl;
import java.util.Calendar;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={LoggerBehaviour.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class LoggerBehaviourImpl
extends EchoBehaviourImpl
implements LoggerBehaviour {
    private Logger log = Logger.getLogger(LoggerBehaviourImpl.class.getName());
    @Property(name="level", required=true)
    private LoggerBehaviour.LEVEL level;

    @Override
    public LoggerBehaviour.LEVEL getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(LoggerBehaviour.LEVEL level) {
        this.level = level;
    }

    @Override
    public void severe(String msg) {
        this.log.severe("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    public void warning(String msg) {
        this.log.warning("[BPEL]  " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    public void info(String msg) {
        this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    public void debug(String msg) {
        this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    protected void doExecute(Execution execution) {
        String msg = this.getNode().getScope().getExpressionEvaluator().evaluateAsString(execution, this.getMessage());
        if (this.level == null) {
            this.severe("Level is null !" + msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.SEVERE)) {
            this.severe(msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.WARNING)) {
            this.warning(msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.INFO)) {
            this.info(msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.DEBUG)) {
            this.debug(msg);
        }
    }
}

