/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.EchoBehaviour;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.AbstractExtendedBehaviourImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value = EchoBehaviour.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class EchoBehaviourImpl extends AbstractExtendedBehaviourImpl implements EchoBehaviour {

    private Logger log = Logger.getLogger(EchoBehaviourImpl.class.getName());

    @Property(name = "message", required = true)
    private Expression message;

    public EchoBehaviourImpl() {

    }

    public Expression getMessage() {
        return this.message;
    }

    public void setMessage(final Expression message) {
        this.message = message;
    }

    @Override
    protected void doExecute(Execution execution) {
        this.log.finest("execute echo behaviour: " + this.message);
        if (this.message != null) {
            String result = getNode().getScope().getExpressionEvaluator().evaluateAsString(execution, message);
            this.log.finest(result);
        }
    }

}
