/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.extended.service.behaviour.api;

import java.net.URL;
import java.util.List;

import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.ExtendedBehaviour;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarLoader;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface ExtendedBehaviourService extends Service {

	JarLoader getCurrentClassLoader();
	List<Class<? extends ExtendedBehaviour>> getExtendedBehaviourInJar(URL jarUrl) throws JarException;
	List<Class<? extends  org.objectweb.fractal.juliac.runtime.Factory>> getFactoriesInJar(URL jarUrl) throws JarException;
}
