/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader;

import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarLoader
extends URLClassLoader {
    private List<Class<?>> classList = new ArrayList();
    private Map<String, List<String>> resources = new HashMap<String, List<String>>();
    private Logger log = Logger.getLogger(JarLoader.class.getCanonicalName());

    public JarLoader(URL url, ClassLoader parent) throws JarException {
        this(url, JarLoader.getAllUrlsInManifest(url), parent);
    }

    private JarLoader(URL parentUrl, URL[] urlsInManifest, ClassLoader parent) {
        super(urlsInManifest, parent);
        this.load(parentUrl);
    }

    private static URL[] getAllUrlsInManifest(URL url) throws JarException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (url != null) {
            ZipInputStream jin = null;
            try {
                File file;
                Manifest manifest = null;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    file = new File(url.getPath());
                }
                jin = new JarInputStream(new FileInputStream(file));
                manifest = ((JarInputStream)jin).getManifest();
                if (manifest != null) {
                    Attributes attr = manifest.getMainAttributes();
                    ArrayList<String> classpath = new ArrayList<String>();
                    if (attr != null && attr.getValue("Class-Path") != null) {
                        StringTokenizer st = new StringTokenizer(attr.getValue("Class-Path"), " ");
                        while (st.hasMoreElements()) {
                            classpath.add(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1) + st.nextToken());
                        }
                    }
                    classpath.add(0, file.toString());
                    for (String fileS : classpath) {
                        urls.add(0, new File(fileS).toURI().toURL());
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new JarException(e);
            }
            catch (IOException e) {
                throw new JarException(e);
            }
            finally {
                if (jin != null) {
                    try {
                        jin.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        URL[] res = new URL[urls.size()];
        return urls.toArray(res);
    }

    public List<Class<?>> getClassList() {
        return this.classList;
    }

    public Map<String, List<String>> getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL url) {
        ZipInputStream jin = null;
        try {
            File file;
            Manifest manifest = null;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                file = new File(url.getPath());
            }
            jin = new JarInputStream(new FileInputStream(file));
            ZipFile zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> zen = zf.entries();
            Hashtable<String, Integer> sizeOfClass = new Hashtable<String, Integer>();
            while (zen.hasMoreElements()) {
                ZipEntry e = zen.nextElement();
                String name = e.getName();
                sizeOfClass.put(name.replace("\\", "/"), (int)e.getSize());
            }
            zf.close();
            Hashtable<String, byte[]> hs = new Hashtable<String, byte[]>();
            JarEntry je = null;
            while ((je = ((JarInputStream)jin).getNextJarEntry()) != null) {
                int blu;
                String name = je.getName().replace("\\", "/");
                int size = (Integer)sizeOfClass.get(name);
                byte[] b = new byte[size];
                int byte_read = 0;
                if (manifest == null && name.equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest();
                    while (byte_read != size) {
                        blu = ((JarInputStream)jin).read(b, byte_read, size - byte_read);
                        if (blu <= 0) continue;
                        byte_read += blu;
                    }
                    manifest.read(new ByteArrayInputStream(b));
                    continue;
                }
                if (!name.endsWith(".class")) {
                    this.addResources(name);
                    continue;
                }
                while (byte_read != size) {
                    blu = ((JarInputStream)jin).read(b, byte_read, size - byte_read);
                    if (blu <= 0) continue;
                    byte_read += blu;
                }
                hs.put(name, b);
            }
            this.defineClassList(hs);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (jin != null) {
                    jin.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void addResources(String name) {
        String extension;
        if (name.contains(".") && (extension = name.substring(name.indexOf(".") + 1, name.length())).length() == 3) {
            List<String> urls = this.resources.get(extension.toLowerCase());
            if (urls == null) {
                urls = new ArrayList<String>();
            }
            urls.add(name);
            this.resources.put(extension, urls);
        }
    }

    public List<Class<?>> defineClassList(Hashtable<String, byte[]> hs) {
        Enumeration<String> en = hs.keys();
        Map<String, byte[]> classes2reload = new HashMap<String, byte[]>();
        while (en.hasMoreElements()) {
            String s = en.nextElement();
            byte[] b = hs.get(s);
            if (!s.endsWith(".class")) continue;
            String name = s.substring(0, s.indexOf(46));
            name = name.replace("/", ".");
            classes2reload.put(name, b);
        }
        classes2reload = this.classes2reload(classes2reload);
        for (int cpt = 0; classes2reload.size() > 0 && cpt < 100; ++cpt) {
            classes2reload = this.classes2reload(classes2reload);
        }
        return this.getClassList();
    }

    private Map<String, byte[]> classes2reload(Map<String, byte[]> classes2reload) {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        Iterator<Map.Entry<String, byte[]>> it = classes2reload.entrySet().iterator();
        Class<?> c = null;
        while (it.hasNext()) {
            Map.Entry<String, byte[]> entry = it.next();
            try {
                c = this.defineClass(entry.getKey(), entry.getValue(), 0, entry.getValue().length);
            }
            catch (LinkageError e) {
                this.log.warning("Impossible to load: " + e.getMessage());
                try {
                    System.err.println("entry.getKey() = " + entry.getKey());
                    c = this.loadClass(entry.getKey());
                }
                catch (ClassNotFoundException e1) {
                    res.put(entry.getKey(), entry.getValue());
                }
                catch (NoClassDefFoundError e1) {
                    res.put(entry.getKey(), entry.getValue());
                }
            }
            if (c != null && !this.classList.contains(entry.getKey())) {
                this.classList.add(c);
            }
            c = null;
        }
        return res;
    }

    public static Object callMethod(Class<?> c, Object inst, String method, Object ... args) throws JarException {
        Object res = null;
        try {
            Method m = null;
            for (int i = 0; i < c.getMethods().length; ++i) {
                if (!c.getMethods()[i].getName().equals("setMessage")) continue;
                m = c.getMethods()[i];
                break;
            }
            res = m.invoke(inst, args);
        }
        catch (IllegalArgumentException e) {
            throw new JarException(e);
        }
        catch (IllegalAccessException e) {
            throw new JarException(e);
        }
        catch (InvocationTargetException e) {
            throw new JarException(e);
        }
        return res;
    }

    public String toString() {
        String res = "";
        for (Class<?> clazz : this.getClassList()) {
            res = clazz.getName() + "\n";
        }
        return res;
    }
}

