/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.extended.service.behaviour.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.AbstractExtendedBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.ExtendedBehaviour;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.api.ExtendedBehaviourService;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarLoader;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ExtendedBehaviourServiceImpl extends AbstractServiceImpl implements ExtendedBehaviourService {

	private Logger log = Logger.getLogger(ExtendedBehaviourServiceImpl.class.getName());

	private final List<ExtendedBehaviour> behaviours = Collections.synchronizedList(new ArrayList<ExtendedBehaviour>());

	protected JarLoader classLoader = null;

	public ExtendedBehaviourServiceImpl(Engine engine) {
		super(engine);
	}

	public void run() {
		try {

			Thread.sleep(this.getRefreshFrequency());

		} catch (Exception e) {
			e.printStackTrace();
			log.severe("Error in auto trash service: " + e.getMessage());
		} 	
	}



	public List<Class<? extends org.objectweb.fractal.juliac.runtime.Factory>> getFactoriesInJar(
			URL jarUrl) throws JarException {
		List<Class<? extends org.objectweb.fractal.juliac.runtime.Factory>> res = null;


		classLoader = new JarLoader(jarUrl,Thread.currentThread().getContextClassLoader());

		res = this.getClassInJar(classLoader, org.objectweb.fractal.juliac.runtime.Factory.class);
		for(Class<? extends org.objectweb.fractal.juliac.runtime.Factory> clazz: res) {
			if(clazz.getName().equals(AbstractExtendedBehaviourImpl.class.getName())) {
				res.remove(clazz);
				break;
			}
		}
		return res;
	}


	public List<Class<? extends ExtendedBehaviour>> getExtendedBehaviourInJar(
			URL jarUrl) throws JarException {
		List<Class<? extends ExtendedBehaviour>> res = null;


		classLoader = new JarLoader(jarUrl,Thread.currentThread().getContextClassLoader());

		res = this.getClassInJar(classLoader, ExtendedBehaviour.class);
		for(Class<? extends ExtendedBehaviour> clazz: res) {
			if(clazz.getName().equals(AbstractExtendedBehaviourImpl.class.getName())) {
				res.remove(clazz);
				break;
			}
		}
		return res;
	}


	protected <C> List<Class<? extends C>> getClassInJar(JarLoader parent, Class<? extends C> class2found) {
		List<Class<? extends C>> res = new ArrayList<Class<? extends C>>();
		
		for(Class<?> c: parent.getClassList()) {
		
			//TODO better strategy in order to avoid Frascati generated classes
			if(!c.isInterface() && isClassExtendOfClass2found(c, class2found)  
			 && !c.getName().endsWith("Factory") && !c.getName().contains("FCscaPrimitiveFC")
			 && !c.getName().endsWith("FcOutItf") && !c.getName().endsWith("FcInItf")
			 && !c.getName().endsWith("FcSR") && !c.getName().endsWith("Intent")
			// && !c.getName().contains("FCscaEasyCompositeWithContentFC")
			 && !c.getName().contains("FCscaEasyPrimitiveFC")
			   ) {
				res.add((Class<? extends C>)c);
			}
		}
		return res;
	}

	private <C> boolean isClassExtendOfClass2found(Class<?> c, Class<? extends C> class2found) {
		boolean res = false;
		try {
			if(c != null) {
				if(c.getName().equals(class2found.getName())) {
					res = true;
				} else if(c.getInterfaces() != null) {
					for(Class<?> subc : c.getInterfaces()) {
						res = isClassExtendOfClass2found(subc, class2found);
						if(res == true) {
							break;
						}
					}
				}
			}
		} catch(ClassCastException e) {

		}
		return res;
	}


	public JarLoader getCurrentClassLoader() {
		return classLoader;
	}





}
