package com.ebmwebsourcing.easysawsdl10.impl;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easysawsdl10.api.anonymoustype.AttrExtensions;

import easybox.org.w3.ns.sawsdl.EJaxbAttrExtensions;

final class AttrExtensionsImpl extends AbstractJaxbXmlObjectImpl<EJaxbAttrExtensions> implements AttrExtensions, WithOtherAttributes {

	protected AttrExtensionsImpl(XmlContext xmlContext, EJaxbAttrExtensions jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbAttrExtensions> getCompliantModelClass() {
    	return EJaxbAttrExtensions.class;
	}
	
    @Override
    public final void addOtherAttribute(QName qname, String value) {
        getModelObject().getOtherAttributes().put(qname, value);
    }

    @Override
    public final void clearOtherAttributes() {
        getModelObject().getOtherAttributes().clear();
    }

    @Override
    public final String getOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().get(qname);
    }

    @Override
    public final Map<QName, String> getOtherAttributes() {
        return new HashMap<QName, String>(getModelObject().getOtherAttributes());
    }

    @Override
    public final boolean hasOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().containsKey(qname);
    }

    @Override
    public final void removeOtherAttribute(QName qname) {
        getModelObject().getOtherAttributes().remove(qname);
    }

}
