package com.ebmwebsourcing.easysawsdl10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easysawsdl10.api.Constants;

// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "easysawsdl10-impl";
    }

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/easysawsdl10";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "easysawsdl10.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.w3.ns.sawsdl.ObjectFactory.class
                .getPackage();
    }

    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.SAWSDL10_NS_URI;
    }

    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.SAWSDL10_NS_PREFERRED_PREFIX;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();

        
        // anonymous types
        factorableClasses.add(AttrExtensionsImpl.class);

        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }

    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject modelObject) throws InstantiationException,
            IllegalAccessException, InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, modelObject);
    }

}
