package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easybox.api.with.WithTargetNamespace;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.easywsdl11.api.element.Types;

public interface TDefinitions extends TExtensibleDocumented, WithName,
        WithTargetNamespace {

    Import[] getImports();

    void addImport(Import impor);

    void removeImport(Import impor);

    void clearImports();

    boolean hasTypes();

    Types getTypes();

    void setTypes(Types types);

    Message[] getMessages();

    void addMessage(Message message);

    void removeMessage(Message message);

    void clearMessages();

    Message getMessageByName(String name);

    PortType[] getPortTypes();

    void addPortType(PortType portType);

    void removePortType(PortType portType);

    void clearPortTypes();

    PortType getPortTypeByName(String name);

    Binding[] getBindings();

    void addBinding(Binding binding);

    void removeBinding(Binding binding);

    void clearBindings();

    Binding getBindingByName(String name);

    Service[] getServices();

    void addService(Service service);

    void removeService(Service service);

    void clearServices();

    Service getServiceByName(String name);

}
