/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easywsdl11.api.element.Fault;
import com.ebmwebsourcing.easywsdl11.api.element.Input;
import com.ebmwebsourcing.easywsdl11.api.element.Output;
import com.ebmwebsourcing.easywsdl11.api.type.TOperation;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class TOperationTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_INPUT = "expectedInput";
    public static final String EXPECTED_OUTPUT = "expectedOutput";
    public static final String EXPECTED_FAULTS = "expectedFaults";

    public TOperationTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testHasInput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Assert.assertEquals((Object)this.hasTestData(EXPECTED_INPUT), (Object)tOperation.hasInput());
    }

    @Test
    public void testGetInput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Assert.assertEquals((Object)this.getTestData(EXPECTED_INPUT), (Object)tOperation.getInput());
    }

    @Test
    public void testSetInput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Input newInput = (Input)this.getXmlContext().getXmlObjectFactory().create(Input.class);
        newInput.setName("newInput");
        tOperation.setInput(newInput);
        Assert.assertEquals((Object)newInput, (Object)tOperation.getInput());
    }

    @Test
    public void testSetNullInput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Input newInput = null;
        tOperation.setInput(newInput);
        Assert.assertEquals(newInput, (Object)tOperation.getInput());
    }

    @Test
    public void testHasOutput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Assert.assertEquals((Object)this.hasTestData(EXPECTED_OUTPUT), (Object)tOperation.hasOutput());
    }

    @Test
    public void testGetOutput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Assert.assertEquals((Object)this.getTestData(EXPECTED_OUTPUT), (Object)tOperation.getOutput());
    }

    @Test
    public void testSetOutput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Output newOutput = (Output)this.getXmlContext().getXmlObjectFactory().create(Output.class);
        newOutput.setName("newOutput");
        tOperation.setOutput(newOutput);
        Assert.assertEquals((Object)newOutput, (Object)tOperation.getOutput());
    }

    @Test
    public void testSetNullOutput() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Output newOutput = null;
        tOperation.setOutput(newOutput);
        Assert.assertEquals(newOutput, (Object)tOperation.getOutput());
    }

    @Test
    public void testGetFaults() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Object[] expectedFaults = (Fault[])this.getTestData(EXPECTED_FAULTS);
        Assert.assertArrayEquals((Object[])expectedFaults, (Object[])tOperation.getFaults());
    }

    @Test
    public void testGetFaultByName() {
        Fault[] expectedFaults;
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        for (Fault expectedFault : expectedFaults = (Fault[])this.getTestData(EXPECTED_FAULTS)) {
            if (expectedFault.getName() == null) continue;
            Assert.assertEquals((Object)expectedFault, (Object)tOperation.getFaultByName(expectedFault.getName()));
        }
    }

    @Test
    public void testAddFault() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        LinkedList<Fault> expectedFaults = new LinkedList<Fault>(Arrays.asList((Fault[])this.getTestData(EXPECTED_FAULTS)));
        Fault newFault = (Fault)this.getXmlContext().getXmlObjectFactory().create(Fault.class);
        newFault.setName("newFaultName");
        expectedFaults.add(newFault);
        tOperation.addFault(newFault);
        Assert.assertEquals(expectedFaults, Arrays.asList(tOperation.getFaults()));
    }

    @Test
    public void testRemoveFault() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        for (Fault e : tOperation.getFaults()) {
            tOperation.removeFault(e);
            Assert.assertFalse((boolean)Arrays.asList(tOperation.getFaults()).contains(e));
        }
    }

    @Test
    public void testClearFaults() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        tOperation.clearFaults();
        Assert.assertEquals((long)0L, (long)tOperation.getFaults().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Fault newFault = (Fault)this.getXmlContext().getXmlObjectFactory().create(Fault.class);
        tOperation.addFault(newFault);
        Assert.assertEquals((Object)tOperation, (Object)newFault.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        TOperation tOperation = (TOperation)this.newXmlObjectUnderTest();
        Fault newFault = (Fault)this.getXmlContext().getXmlObjectFactory().create(Fault.class);
        tOperation.addFault(newFault);
        tOperation.removeFault(newFault);
        Assert.assertNull((Object)newFault.getXmlObjectParent());
    }
}

