/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easybox.api.with.WithTargetNamespace;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.easywsdl11.api.element.Types;

public interface TDefinitions extends TExtensibleDocumented, WithName,
        WithTargetNamespace {

    Import[] getImports();

    void addImport(Import impor);

    void removeImport(Import impor);

    void clearImports();

    boolean hasTypes();

    Types getTypes();

    void setTypes(Types types);

    Message[] getMessages();

    void addMessage(Message message);

    void removeMessage(Message message);

    void clearMessages();

    Message getMessageByName(String name);

    PortType[] getPortTypes();

    void addPortType(PortType portType);

    void removePortType(PortType portType);

    void clearPortTypes();

    PortType getPortTypeByName(String name);

    Binding[] getBindings();

    void addBinding(Binding binding);

    void removeBinding(Binding binding);

    void clearBindings();

    Binding getBindingByName(String name);

    Service[] getServices();

    void addService(Service service);

    void removeService(Service service);

    void clearServices();

    Service getServiceByName(String name);

}
