/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperation;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.type.TBinding;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class TBindingTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_BINDING_OPERATIONS = "expectedBindingOperations";
    public static final String EXPECTED_PORT_TYPE = "expectedPortType";

    public TBindingTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetOperations() {
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        Object[] expectedOperations = (BindingOperation[])this.getTestData(EXPECTED_BINDING_OPERATIONS);
        Assert.assertArrayEquals((Object[])expectedOperations, (Object[])tBinding.getOperations());
    }

    @Test
    public void testGetOperationByName() {
        BindingOperation[] expectedOperations;
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        for (BindingOperation expectedOperation : expectedOperations = (BindingOperation[])this.getTestData(EXPECTED_BINDING_OPERATIONS)) {
            if (expectedOperation.getName() == null) continue;
            Assert.assertEquals((Object)expectedOperation, (Object)tBinding.getOperationByName(expectedOperation.getName()));
        }
    }

    @Test
    public void testAddOperation() {
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        LinkedList<BindingOperation> expectedOperations = new LinkedList<BindingOperation>(Arrays.asList((BindingOperation[])this.getTestData(EXPECTED_BINDING_OPERATIONS)));
        BindingOperation newOperation = (BindingOperation)this.getXmlContext().getXmlObjectFactory().create(BindingOperation.class);
        newOperation.setName("newOperationName");
        expectedOperations.add(newOperation);
        tBinding.addOperation(newOperation);
        Assert.assertEquals(expectedOperations, Arrays.asList(tBinding.getOperations()));
    }

    @Test
    public void testRemoveOperation() {
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        for (BindingOperation e : tBinding.getOperations()) {
            tBinding.removeOperation(e);
            Assert.assertFalse((boolean)Arrays.asList(tBinding.getOperations()).contains(e));
        }
    }

    @Test
    public void testClearOperations() {
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        tBinding.clearOperations();
        Assert.assertEquals((long)0L, (long)tBinding.getOperations().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        BindingOperation newOperation = (BindingOperation)this.getXmlContext().getXmlObjectFactory().create(BindingOperation.class);
        tBinding.addOperation(newOperation);
        Assert.assertEquals((Object)tBinding, (Object)newOperation.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        BindingOperation newOperation = (BindingOperation)this.getXmlContext().getXmlObjectFactory().create(BindingOperation.class);
        tBinding.addOperation(newOperation);
        tBinding.removeOperation(newOperation);
        Assert.assertNull((Object)newOperation.getXmlObjectParent());
    }

    @Test
    public void testFindPortType() {
        TBinding tBinding = (TBinding)this.newXmlObjectUnderTest();
        PortType expectedPortType = (PortType)this.getTestData(EXPECTED_PORT_TYPE);
        Assert.assertEquals((Object)expectedPortType, (Object)tBinding.findPortType());
    }
}

