/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.easywsdl11.api.element.Types;
import com.ebmwebsourcing.easywsdl11.api.type.TDefinitions;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class TDefinitionsTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_IMPORTS = "expectedImports";
    public static final String EXPECTED_TYPES = "expectedTypes";
    public static final String EXPECTED_MESSAGES = "expectedMessages";
    public static final String EXPECTED_PORTTYPES = "expectedPortTypes";
    public static final String EXPECTED_BINDINGS = "expectedBindings";
    public static final String EXPECTED_SERVICES = "expectedServices";

    public TDefinitionsTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetImports() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Object[] expectedImports = (Import[])this.getTestData(EXPECTED_IMPORTS);
        Assert.assertArrayEquals((Object[])expectedImports, (Object[])tDefinitions.getImports());
    }

    @Test
    public void testAddImport() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        LinkedList<Import> expectedImports = new LinkedList<Import>(Arrays.asList((Import[])this.getTestData(EXPECTED_IMPORTS)));
        Import newImport = (Import)this.getXmlContext().getXmlObjectFactory().create(Import.class);
        newImport.setLocation("newImportLocation");
        expectedImports.add(newImport);
        tDefinitions.addImport(newImport);
        Assert.assertEquals(expectedImports, Arrays.asList(tDefinitions.getImports()));
    }

    @Test
    public void testRemoveImport() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (Import e : tDefinitions.getImports()) {
            tDefinitions.removeImport(e);
            Assert.assertFalse((boolean)Arrays.asList(tDefinitions.getImports()).contains(e));
        }
    }

    @Test
    public void testClearImports() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        tDefinitions.clearImports();
        Assert.assertEquals((long)0L, (long)tDefinitions.getImports().length);
    }

    @Test
    public void testGetParentAfterImportAdding() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Import newImport = (Import)this.getXmlContext().getXmlObjectFactory().create(Import.class);
        tDefinitions.addImport(newImport);
        Assert.assertEquals((Object)tDefinitions, (Object)newImport.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterImportRemoval() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Import newImport = (Import)this.getXmlContext().getXmlObjectFactory().create(Import.class);
        tDefinitions.addImport(newImport);
        tDefinitions.removeImport(newImport);
        Assert.assertNull((Object)newImport.getXmlObjectParent());
    }

    @Test
    public void testHasTypes() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Assert.assertEquals((Object)this.hasTestData(EXPECTED_TYPES), (Object)tDefinitions.hasTypes());
    }

    @Test
    public void testGetTypes() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Assert.assertEquals((Object)this.getTestData(EXPECTED_TYPES), (Object)tDefinitions.getTypes());
    }

    @Test
    public void testSetTypes() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Types newTypes = (Types)this.getXmlContext().getXmlObjectFactory().create(Types.class);
        tDefinitions.setTypes(newTypes);
        Assert.assertEquals((Object)newTypes, (Object)tDefinitions.getTypes());
    }

    @Test
    public void testSetNullTypes() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Types newTypes = null;
        tDefinitions.setTypes(newTypes);
        Assert.assertEquals(newTypes, (Object)tDefinitions.getTypes());
    }

    @Test
    public void testGetMessages() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Object[] expectedMessages = (Message[])this.getTestData(EXPECTED_MESSAGES);
        Assert.assertArrayEquals((Object[])expectedMessages, (Object[])tDefinitions.getMessages());
    }

    @Test
    public void testGetMessageByName() {
        Message[] expectedMessages;
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (Message expectedMessage : expectedMessages = (Message[])this.getTestData(EXPECTED_MESSAGES)) {
            if (expectedMessage.getName() == null) continue;
            Assert.assertEquals((Object)expectedMessage, (Object)tDefinitions.getMessageByName(expectedMessage.getName()));
        }
    }

    @Test
    public void testAddMessage() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        LinkedList<Message> expectedMessages = new LinkedList<Message>(Arrays.asList((Message[])this.getTestData(EXPECTED_MESSAGES)));
        Message newMessage = (Message)this.getXmlContext().getXmlObjectFactory().create(Message.class);
        newMessage.setName("newMessageName");
        expectedMessages.add(newMessage);
        tDefinitions.addMessage(newMessage);
        Assert.assertEquals(expectedMessages, Arrays.asList(tDefinitions.getMessages()));
    }

    @Test
    public void testRemoveMessage() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (Message e : tDefinitions.getMessages()) {
            tDefinitions.removeMessage(e);
            Assert.assertFalse((boolean)Arrays.asList(tDefinitions.getMessages()).contains(e));
        }
    }

    @Test
    public void testClearMessages() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        tDefinitions.clearMessages();
        Assert.assertEquals((long)0L, (long)tDefinitions.getMessages().length);
    }

    @Test
    public void testGetParentAfterMessageAdding() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Message newMessage = (Message)this.getXmlContext().getXmlObjectFactory().create(Message.class);
        tDefinitions.addMessage(newMessage);
        Assert.assertEquals((Object)tDefinitions, (Object)newMessage.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterMessageRemoval() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Message newMessage = (Message)this.getXmlContext().getXmlObjectFactory().create(Message.class);
        tDefinitions.addMessage(newMessage);
        tDefinitions.removeMessage(newMessage);
        Assert.assertNull((Object)newMessage.getXmlObjectParent());
    }

    @Test
    public void testGetPortTypes() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Object[] expectedPortTypes = (PortType[])this.getTestData(EXPECTED_PORTTYPES);
        Assert.assertArrayEquals((Object[])expectedPortTypes, (Object[])tDefinitions.getPortTypes());
    }

    @Test
    public void testGetPortTypeByName() {
        PortType[] expectedPortTypes;
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (PortType expectedPortType : expectedPortTypes = (PortType[])this.getTestData(EXPECTED_PORTTYPES)) {
            if (expectedPortType.getName() == null) continue;
            Assert.assertEquals((Object)expectedPortType, (Object)tDefinitions.getPortTypeByName(expectedPortType.getName()));
        }
    }

    @Test
    public void testAddPortType() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        LinkedList<PortType> expectedPortTypes = new LinkedList<PortType>(Arrays.asList((PortType[])this.getTestData(EXPECTED_PORTTYPES)));
        PortType newPortType = (PortType)this.getXmlContext().getXmlObjectFactory().create(PortType.class);
        newPortType.setName("newPortTypeName");
        expectedPortTypes.add(newPortType);
        tDefinitions.addPortType(newPortType);
        Assert.assertEquals(expectedPortTypes, Arrays.asList(tDefinitions.getPortTypes()));
    }

    @Test
    public void testRemovePortType() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (PortType e : tDefinitions.getPortTypes()) {
            tDefinitions.removePortType(e);
            Assert.assertFalse((boolean)Arrays.asList(tDefinitions.getPortTypes()).contains(e));
        }
    }

    @Test
    public void testClearPortTypes() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        tDefinitions.clearPortTypes();
        Assert.assertEquals((long)0L, (long)tDefinitions.getPortTypes().length);
    }

    @Test
    public void testGetParentAfterPortTypeAdding() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        PortType newPortType = (PortType)this.getXmlContext().getXmlObjectFactory().create(PortType.class);
        tDefinitions.addPortType(newPortType);
        Assert.assertEquals((Object)tDefinitions, (Object)newPortType.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterPortTypeRemoval() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        PortType newPortType = (PortType)this.getXmlContext().getXmlObjectFactory().create(PortType.class);
        tDefinitions.addPortType(newPortType);
        tDefinitions.removePortType(newPortType);
        Assert.assertNull((Object)newPortType.getXmlObjectParent());
    }

    @Test
    public void testGetBindings() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Object[] expectedBindings = (Binding[])this.getTestData(EXPECTED_BINDINGS);
        Assert.assertArrayEquals((Object[])expectedBindings, (Object[])tDefinitions.getBindings());
    }

    @Test
    public void testGetBindingByName() {
        Binding[] expectedBindings;
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (Binding expectedBinding : expectedBindings = (Binding[])this.getTestData(EXPECTED_BINDINGS)) {
            if (expectedBinding.getName() == null) continue;
            Assert.assertEquals((Object)expectedBinding, (Object)tDefinitions.getBindingByName(expectedBinding.getName()));
        }
    }

    @Test
    public void testAddBinding() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        LinkedList<Binding> expectedBindings = new LinkedList<Binding>(Arrays.asList((Binding[])this.getTestData(EXPECTED_BINDINGS)));
        Binding newBinding = (Binding)this.getXmlContext().getXmlObjectFactory().create(Binding.class);
        newBinding.setName("newBindingName");
        expectedBindings.add(newBinding);
        tDefinitions.addBinding(newBinding);
        Assert.assertEquals(expectedBindings, Arrays.asList(tDefinitions.getBindings()));
    }

    @Test
    public void testRemoveBinding() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (Binding e : tDefinitions.getBindings()) {
            tDefinitions.removeBinding(e);
            Assert.assertFalse((boolean)Arrays.asList(tDefinitions.getBindings()).contains(e));
        }
    }

    @Test
    public void testClearBindings() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        tDefinitions.clearBindings();
        Assert.assertEquals((long)0L, (long)tDefinitions.getBindings().length);
    }

    @Test
    public void testGetParentAfterBindingAdding() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Binding newBinding = (Binding)this.getXmlContext().getXmlObjectFactory().create(Binding.class);
        tDefinitions.addBinding(newBinding);
        Assert.assertEquals((Object)tDefinitions, (Object)newBinding.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterBindingRemoval() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Binding newBinding = (Binding)this.getXmlContext().getXmlObjectFactory().create(Binding.class);
        tDefinitions.addBinding(newBinding);
        tDefinitions.removeBinding(newBinding);
        Assert.assertNull((Object)newBinding.getXmlObjectParent());
    }

    @Test
    public void testGetServices() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Object[] expectedServices = (Service[])this.getTestData(EXPECTED_SERVICES);
        Assert.assertArrayEquals((Object[])expectedServices, (Object[])tDefinitions.getServices());
    }

    @Test
    public void testGetServiceByName() {
        Service[] expectedServices;
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (Service expectedService : expectedServices = (Service[])this.getTestData(EXPECTED_SERVICES)) {
            if (expectedService.getName() == null) continue;
            Assert.assertEquals((Object)expectedService, (Object)tDefinitions.getServiceByName(expectedService.getName()));
        }
    }

    @Test
    public void testAddService() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        LinkedList<Service> expectedServices = new LinkedList<Service>(Arrays.asList((Service[])this.getTestData(EXPECTED_SERVICES)));
        Service newService = (Service)this.getXmlContext().getXmlObjectFactory().create(Service.class);
        newService.setName("newServiceName");
        expectedServices.add(newService);
        tDefinitions.addService(newService);
        Assert.assertEquals(expectedServices, Arrays.asList(tDefinitions.getServices()));
    }

    @Test
    public void testRemoveService() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        for (Service e : tDefinitions.getServices()) {
            tDefinitions.removeService(e);
            Assert.assertFalse((boolean)Arrays.asList(tDefinitions.getServices()).contains(e));
        }
    }

    @Test
    public void testClearServices() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        tDefinitions.clearServices();
        Assert.assertEquals((long)0L, (long)tDefinitions.getServices().length);
    }

    @Test
    public void testGetParentAfterServiceAdding() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Service newService = (Service)this.getXmlContext().getXmlObjectFactory().create(Service.class);
        tDefinitions.addService(newService);
        Assert.assertEquals((Object)tDefinitions, (Object)newService.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterServiceRemoval() {
        TDefinitions tDefinitions = (TDefinitions)this.newXmlObjectUnderTest();
        Service newService = (Service)this.getXmlContext().getXmlObjectFactory().create(Service.class);
        tDefinitions.addService(newService);
        tDefinitions.removeService(newService);
        Assert.assertNull((Object)newService.getXmlObjectParent());
    }
}

