package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Documentation;
import com.ebmwebsourcing.easywsdl11.api.type.TDocumented;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTDocumented;

abstract class AbstractTDocumentedImpl<Model extends EJaxbTDocumented> extends
        AbstractWsdlXmlObjectImpl<Model> implements TDocumented {

    protected AbstractTDocumentedImpl(XmlContext xmlContext, Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public final boolean hasDocumentation() {
        return getModelObject().getDocumentation() != null;
    }

    @Override
    public final Documentation getDocumentation() {
        if (getModelObject().getDocumentation() == null)
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(
                getModelObject().getDocumentation(), Documentation.class);
    }

    @Override
    public final void setDocumentation(Documentation documentation) {
        if (documentation == null) {
            getModelObject().setDocumentation(null);
            return;
        }
        assert documentation instanceof TDocumentationImpl;
        TDocumentationImpl documentationImpl = (TDocumentationImpl) documentation;
        getModelObject().setDocumentation(documentationImpl.getModelObject());
    }

}
