package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperationFault;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperationInput;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperationOutput;
import com.ebmwebsourcing.easywsdl11.api.type.TBindingOperation;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTBindingOperation;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTBindingOperationFault;

class TBindingOperationImpl extends
        AbstractTExtensibleDocumentedImpl<EJaxbTBindingOperation> implements
        TBindingOperation {

    protected TBindingOperationImpl(XmlContext xmlContext,
            EJaxbTBindingOperation jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTBindingOperation> getCompliantModelClass() {
        return EJaxbTBindingOperation.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasInput() {
        return getModelObject().getInput() != null;
    }

    @Override
    public BindingOperationInput getInput() {
        if (!hasInput())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(
                getModelObject().getInput(), BindingOperationInput.class);
    }

    @Override
    public void setInput(BindingOperationInput input) {
        if (input == null) {
            getModelObject().setInput(null);
        } else {
            getModelObject().setInput(
                    ((BindingOperationInputImpl) input).getModelObject());
        }
    }

    @Override
    public boolean hasOutput() {
        return getModelObject().getOutput() != null;
    }

    @Override
    public BindingOperationOutput getOutput() {
        if (!hasOutput())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(
                getModelObject().getOutput(), BindingOperationOutput.class);
    }

    @Override
    public void setOutput(BindingOperationOutput output) {
        if (output == null) {
            getModelObject().setOutput(null);
        } else {
            getModelObject().setOutput(
                    ((BindingOperationOutputImpl) output).getModelObject());
        }
    }

    @Override
    public BindingOperationFault[] getFaults() {
        return createChildrenArray(getModelObject().getFault(),
                EJaxbTBindingOperationFault.class, ANY_QNAME,
                BindingOperationFault.class);
    }

    @Override
    public void addFault(BindingOperationFault fault) {
        addToChildren(getModelObject().getFault(), fault);

    }

    @Override
    public void removeFault(BindingOperationFault fault) {
        removeFromChildren(getModelObject().getFault(), fault);
    }

    @Override
    public void clearFaults() {
        clearChildren(getModelObject().getFault(),
                EJaxbTBindingOperationFault.class, ANY_QNAME);
    }

    @Override
    public BindingOperationFault getFaultByName(String name) {
        return getChildByName(getFaults(), name);
    }

}
