package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.easywsdl11.api.element.Types;
import com.ebmwebsourcing.easywsdl11.api.type.TDefinitions;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTBinding;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTDefinitions;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTImport;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTMessage;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPortType;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTService;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTTypes;

class TDefinitionsImpl extends
        AbstractTExtensibleDocumentedImpl<EJaxbTDefinitions> implements
        TDefinitions {

    protected TDefinitionsImpl(XmlContext xmlContext,
            EJaxbTDefinitions jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTDefinitions> getCompliantModelClass() {
        return EJaxbTDefinitions.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasTargetNamespace() {
        return getModelObject().getTargetNamespace() != null;
    }

    @Override
    public String getTargetNamespace() {
        return getModelObject().getTargetNamespace();
    }

    @Override
    public void setTargetNamespace(String targetNamespace) {
        getModelObject().setTargetNamespace(targetNamespace);
    }

    @Override
    public Import[] getImports() {
        return createChildrenArray(getModelObject()
                .getAnyTopLevelOptionalElement(), EJaxbTImport.class,
                ANY_QNAME, Import.class);
    }

    @Override
    public void addImport(Import impor) {
        addToChildren(getModelObject().getAnyTopLevelOptionalElement(), impor);
    }

    @Override
    public void removeImport(Import impor) {
        removeFromChildren(getModelObject().getAnyTopLevelOptionalElement(),
                impor);
    }

    @Override
    public void clearImports() {
        clearChildren(getModelObject().getAnyTopLevelOptionalElement(),
                EJaxbTImport.class, ANY_QNAME);
    }

    @Override
    public boolean hasTypes() {
        return getTypes() != null;
    }

    @Override
    public Types getTypes() {
        Types[] types = createChildrenArray(getModelObject()
                .getAnyTopLevelOptionalElement(), EJaxbTTypes.class, ANY_QNAME,
                Types.class);
        assert types.length <= 1;
        return types.length == 1 ? types[0] : null;
    }

    @Override
    public void setTypes(Types types) {
        clearChildren(getModelObject().getAnyTopLevelOptionalElement(),
                EJaxbTTypes.class, ANY_QNAME);
        if (types != null) {
            addToChildren(getModelObject().getAnyTopLevelOptionalElement(),
                    types);
        }
    }

    @Override
    public Message[] getMessages() {
        return createChildrenArray(getModelObject()
                .getAnyTopLevelOptionalElement(), EJaxbTMessage.class,
                ANY_QNAME, Message.class);
    }

    @Override
    public void addMessage(Message message) {
        addToChildren(getModelObject().getAnyTopLevelOptionalElement(), message);
    }

    @Override
    public void removeMessage(Message message) {
        removeFromChildren(getModelObject().getAnyTopLevelOptionalElement(),
                message);
    }

    @Override
    public void clearMessages() {
        clearChildren(getModelObject().getAnyTopLevelOptionalElement(),
                EJaxbTMessage.class, ANY_QNAME);
    }

    @Override
    public Message getMessageByName(String name) {
        return getChildByName(getMessages(), name);
    }

    @Override
    public PortType[] getPortTypes() {
        return createChildrenArray(getModelObject()
                .getAnyTopLevelOptionalElement(), EJaxbTPortType.class,
                ANY_QNAME, PortType.class);
    }

    @Override
    public void addPortType(PortType portType) {
        addToChildren(getModelObject().getAnyTopLevelOptionalElement(),
                portType);
    }

    @Override
    public void removePortType(PortType portType) {
        removeFromChildren(getModelObject().getAnyTopLevelOptionalElement(),
                portType);

    }

    @Override
    public void clearPortTypes() {
        clearChildren(getModelObject().getAnyTopLevelOptionalElement(),
                EJaxbTPortType.class, ANY_QNAME);
    }

    @Override
    public PortType getPortTypeByName(String name) {
        return getChildByName(getPortTypes(), name);
    }

    @Override
    public Binding[] getBindings() {
        return createChildrenArray(getModelObject()
                .getAnyTopLevelOptionalElement(), EJaxbTBinding.class,
                ANY_QNAME, Binding.class);
    }

    @Override
    public void addBinding(Binding binding) {
        addToChildren(getModelObject().getAnyTopLevelOptionalElement(), binding);
    }

    @Override
    public void removeBinding(Binding binding) {
        removeFromChildren(getModelObject().getAnyTopLevelOptionalElement(),
                binding);
    }

    @Override
    public void clearBindings() {
        clearChildren(getModelObject().getAnyTopLevelOptionalElement(),
                EJaxbTBinding.class, ANY_QNAME);
    }

    @Override
    public Binding getBindingByName(String name) {
        return getChildByName(getBindings(), name);
    }

    @Override
    public Service[] getServices() {
        return createChildrenArray(getModelObject()
                .getAnyTopLevelOptionalElement(), EJaxbTService.class,
                ANY_QNAME, Service.class);
    }

    @Override
    public void addService(Service service) {
        addToChildren(getModelObject().getAnyTopLevelOptionalElement(), service);
    }

    @Override
    public void removeService(Service service) {
        removeFromChildren(getModelObject().getAnyTopLevelOptionalElement(),
                service);
    }

    @Override
    public void clearServices() {
        clearChildren(getModelObject().getAnyTopLevelOptionalElement(),
                EJaxbTService.class, ANY_QNAME);
    }

    @Override
    public Service getServiceByName(String name) {
        return getChildByName(getServices(), name);
    }

}
