package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Operation;
import com.ebmwebsourcing.easywsdl11.api.type.TPortType;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTOperation;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPortType;

class TPortTypeImpl extends
        AbstractTExtensibleAttributesDocumentedImpl<EJaxbTPortType> implements
        TPortType {

    protected TPortTypeImpl(XmlContext xmlContext, EJaxbTPortType jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTPortType> getCompliantModelClass() {
        return EJaxbTPortType.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public Operation[] getOperations() {
        return createChildrenArray(getModelObject().getOperation(),
                EJaxbTOperation.class, ANY_QNAME, Operation.class);
    }

    @Override
    public void addOperation(Operation operation) {
        addToChildren(getModelObject().getOperation(), operation);
    }

    @Override
    public void removeOperation(Operation operation) {
        removeFromChildren(getModelObject().getOperation(), operation);
    }

    @Override
    public void clearOperations() {
        clearChildren(getModelObject().getOperation(), EJaxbTOperation.class,
                ANY_QNAME);
    }

    @Override
    public Operation getOperationByName(String name) {
        return getChildByName(getOperations(), name);
    }

}
