package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.type.TService;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPort;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTService;

class TServiceImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTService>
        implements TService {

    protected TServiceImpl(XmlContext xmlContext, EJaxbTService jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTService> getCompliantModelClass() {
        return EJaxbTService.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public Port[] getPorts() {
        return createChildrenArray(getModelObject().getPort(),
                EJaxbTPort.class, ANY_QNAME, Port.class);
    }

    @Override
    public void addPort(Port port) {
        addToChildren(getModelObject().getPort(), port);
    }

    @Override
    public void removePort(Port port) {
        removeFromChildren(getModelObject().getPort(), port);
    }

    @Override
    public void clearPorts() {
        clearChildren(getModelObject().getPort(), EJaxbTPort.class, ANY_QNAME);
    }

    @Override
    public Port getPortByName(String name) {
        return getChildByName(getPorts(), name);
    }
    
    @Override
    public QName inferQName() {
        String localPart = getName();
        if (localPart == null) return null;
        Definitions parentDefinitions = WsdlHelper.findParentDefinitions(this);
        if (parentDefinitions == null) return new QName(localPart);
        return new QName(parentDefinitions.getTargetNamespace(), localPart);
    }

}
