package com.ebmwebsourcing.easywsdl11.impl;

import java.util.IdentityHashMap;
import java.util.logging.Logger;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easyschema10.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.type.TTypes;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTTypes;

class TTypesImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTTypes>
        implements TTypes {

    private static Logger LOG = Logger.getLogger(TImportImpl.class
            .getName());
    
    protected TTypesImpl(XmlContext xmlContext, EJaxbTTypes jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTTypes> getCompliantModelClass() {
        return EJaxbTTypes.class;
    }

    @Override
    protected XmlObject doCreateAdoptableChild(XmlObject parentAdopter,
            String publicId, String systemId,
            IdentityHashMap<XmlObject, Object> alreadyProcessed)  {
        if (publicId == null) {
            LOG.warning("No public id provided.");
        }
        // Special case : if no system id is given 
        // check that adopted child is not in <types> children.
        if (systemId == null) {
            if (parentAdopter instanceof Import) {
                for (XmlObjectNode xon : getXmlObjectNaturalChildren()) {
                    if (!(xon instanceof Schema))
                        continue;
                    Schema schema = (Schema) xon;
                    if (publicId.equals(schema.getTargetNamespace())) {
                        return schema;
                    }
                }
            }
        }
        return super.doCreateAdoptableChild(parentAdopter, publicId, systemId,
                alreadyProcessed);
    }
}
