package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperation;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.type.TBinding;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTBinding;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTBindingOperation;

class TBindingImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTBinding>
        implements TBinding {

    protected TBindingImpl(XmlContext xmlContext, EJaxbTBinding jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTBinding> getCompliantModelClass() {
        return EJaxbTBinding.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasType() {
        return getModelObject().getType() != null;
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
    }

    @Override
    public BindingOperation[] getOperations() {
        return createChildrenArray(getModelObject().getOperation(),
                EJaxbTBindingOperation.class, ANY_QNAME, BindingOperation.class);
    }

    @Override
    public void addOperation(BindingOperation operation) {
        addToChildren(getModelObject().getOperation(), operation);
    }

    @Override
    public void removeOperation(BindingOperation operation) {
        removeFromChildren(getModelObject().getOperation(), operation);
    }

    @Override
    public void clearOperations() {
        clearChildren(getModelObject().getOperation(),
                EJaxbTBindingOperation.class, ANY_QNAME);
    }

    @Override
    public BindingOperation getOperationByName(String name) {
        return getChildByName(getOperations(), name);
    }
    
    @Override
    public PortType findPortType() {
        XmlObjectXPathEvaluator xpathEvaluator = getXmlContext().createXPathEvaluator();
        QName type = getType();
        try {
            PortType result = xpathEvaluator.selectSingleXmlObjectNode(getXmlObjectBaseRoot(), 
                    String.format("//wsdl11:portType[@name='%s' and ../@targetNamespace='%s']", 
                            type.getLocalPart(), type.getNamespaceURI()), PortType.class);
            return result;
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
    }

}
