package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Part;
import com.ebmwebsourcing.easywsdl11.api.type.TMessage;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTMessage;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPart;

class TMessageImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTMessage>
        implements TMessage {

    protected TMessageImpl(XmlContext xmlContext, EJaxbTMessage jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTMessage> getCompliantModelClass() {
        return EJaxbTMessage.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public Part[] getParts() {
        return createChildrenArray(getModelObject().getPart(),
                EJaxbTPart.class, ANY_QNAME, Part.class);
    }

    @Override
    public void addPart(Part part) {
        addToChildren(getModelObject().getPart(), part);
    }

    @Override
    public void removePart(Part part) {
        removeFromChildren(getModelObject().getPart(), part);
    }

    @Override
    public void clearParts() {
        clearChildren(getModelObject().getPart(), EJaxbTPart.class, ANY_QNAME);
    }

    @Override
    public Part getPartByName(String name) {
        return getChildByName(getParts(), name);
    }

}
