package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Fault;
import com.ebmwebsourcing.easywsdl11.api.element.Input;
import com.ebmwebsourcing.easywsdl11.api.element.Output;
import com.ebmwebsourcing.easywsdl11.api.type.TOperation;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTFault;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTOperation;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTParam;

class TOperationImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTOperation>
        implements TOperation {

    protected TOperationImpl(XmlContext xmlContext, EJaxbTOperation jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTOperation> getCompliantModelClass() {
        return EJaxbTOperation.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasInput() {
        return getInput() != null;
    }

    @Override
    public Input getInput() {
        Input[] inputs = createChildrenArray(getModelObject().getRest(),
                EJaxbTParam.class, Input.QNAME, Input.class);
        assert inputs.length <= 1;
        return inputs.length == 1 ? inputs[0] : null;
    }

    @Override
    public void setInput(Input input) {
        clearChildren(getModelObject().getRest(), EJaxbTParam.class,
                Input.QNAME);
        if (input != null) {
            addToChildren(getModelObject().getRest(), input);
        }
    }

    @Override
    public boolean hasOutput() {
        return getOutput() != null;
    }

    @Override
    public Output getOutput() {
        Output[] outputs = createChildrenArray(getModelObject().getRest(),
                EJaxbTParam.class, Output.QNAME, Output.class);
        assert outputs.length <= 1;
        return outputs.length == 1 ? outputs[0] : null;
    }

    @Override
    public void setOutput(Output output) {
        clearChildren(getModelObject().getRest(), EJaxbTParam.class,
                Output.QNAME);
        if (output != null) {
            addToChildren(getModelObject().getRest(), output);
        }
    }

    @Override
    public Fault[] getFaults() {
        return createChildrenArray(getModelObject().getRest(),
                EJaxbTFault.class, Fault.QNAME, Fault.class);
    }

    @Override
    public void addFault(Fault fault) {
        addToChildren(getModelObject().getRest(), fault);
    }

    @Override
    public void removeFault(Fault fault) {
        removeFromChildren(getModelObject().getRest(), fault);
    }

    @Override
    public void clearFaults() {
        clearChildren(getModelObject().getRest(), EJaxbTFault.class,
                Fault.QNAME);
    }

    @Override
    public Fault getFaultByName(String name) {
        return getChildByName(getFaults(), name);
    }

}
