package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.type.TParam;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTParam;

class TParamImpl extends
        AbstractTExtensibleAttributesDocumentedImpl<EJaxbTParam> implements
        TParam {

    protected TParamImpl(XmlContext xmlContext, EJaxbTParam jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTParam> getCompliantModelClass() {
        return EJaxbTParam.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasMessage() {
        return getModelObject().getMessage() != null;
    }

    @Override
    public QName getMessage() {
        return getModelObject().getMessage();
    }

    @Override
    public void setMessage(QName message) {
        getModelObject().setMessage(message);
    }
    
    @Override
    public Message findMessage() {
        XmlObjectXPathEvaluator xpathEvaluator = getXmlContext().createXPathEvaluator();
        QName messageQName = getMessage();
        try {
            Message result = xpathEvaluator.selectSingleXmlObjectNode(getXmlObjectBaseRoot(), 
                    String.format("//wsdl11:message[@name='%s' and ../@targetNamespace='%s']", 
                            messageQName.getLocalPart(), messageQName.getNamespaceURI()), Message.class);
            return result;
            
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
    }
    
}
