/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Operation;
import com.ebmwebsourcing.easywsdl11.api.type.TPortType;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTOperation;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPortType;

class TPortTypeImpl extends
        AbstractTExtensibleAttributesDocumentedImpl<EJaxbTPortType> implements
        TPortType {

    protected TPortTypeImpl(XmlContext xmlContext, EJaxbTPortType jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTPortType> getCompliantModelClass() {
        return EJaxbTPortType.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public Operation[] getOperations() {
        return createChildrenArray(getModelObject().getOperation(),
                EJaxbTOperation.class, ANY_QNAME, Operation.class);
    }

    @Override
    public void addOperation(Operation operation) {
        addToChildren(getModelObject().getOperation(), operation);
    }

    @Override
    public void removeOperation(Operation operation) {
        removeFromChildren(getModelObject().getOperation(), operation);
    }

    @Override
    public void clearOperations() {
        clearChildren(getModelObject().getOperation(), EJaxbTOperation.class,
                ANY_QNAME);
    }

    @Override
    public Operation getOperationByName(String name) {
        return getChildByName(getOperations(), name);
    }

}
