/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperationFault;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperationInput;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperationOutput;
import com.ebmwebsourcing.easywsdl11.api.type.TBindingOperation;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTBindingOperation;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTBindingOperationFault;

class TBindingOperationImpl extends
        AbstractTExtensibleDocumentedImpl<EJaxbTBindingOperation> implements
        TBindingOperation {

    protected TBindingOperationImpl(XmlContext xmlContext,
            EJaxbTBindingOperation jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTBindingOperation> getCompliantModelClass() {
        return EJaxbTBindingOperation.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasInput() {
        return getModelObject().getInput() != null;
    }

    @Override
    public BindingOperationInput getInput() {
        if (!hasInput())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(
                getModelObject().getInput(), BindingOperationInput.class);
    }

    @Override
    public void setInput(BindingOperationInput input) {
        if (input == null) {
            getModelObject().setInput(null);
        } else {
            getModelObject().setInput(
                    ((BindingOperationInputImpl) input).getModelObject());
        }
    }

    @Override
    public boolean hasOutput() {
        return getModelObject().getOutput() != null;
    }

    @Override
    public BindingOperationOutput getOutput() {
        if (!hasOutput())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(
                getModelObject().getOutput(), BindingOperationOutput.class);
    }

    @Override
    public void setOutput(BindingOperationOutput output) {
        if (output == null) {
            getModelObject().setOutput(null);
        } else {
            getModelObject().setOutput(
                    ((BindingOperationOutputImpl) output).getModelObject());
        }
    }

    @Override
    public BindingOperationFault[] getFaults() {
        return createChildrenArray(getModelObject().getFault(),
                EJaxbTBindingOperationFault.class, ANY_QNAME,
                BindingOperationFault.class);
    }

    @Override
    public void addFault(BindingOperationFault fault) {
        addToChildren(getModelObject().getFault(), fault);

    }

    @Override
    public void removeFault(BindingOperationFault fault) {
        removeFromChildren(getModelObject().getFault(), fault);
    }

    @Override
    public void clearFaults() {
        clearChildren(getModelObject().getFault(),
                EJaxbTBindingOperationFault.class, ANY_QNAME);
    }

    @Override
    public BindingOperationFault getFaultByName(String name) {
        return getChildByName(getFaults(), name);
    }

}
