/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Part;
import com.ebmwebsourcing.easywsdl11.api.type.TMessage;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTMessage;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPart;

class TMessageImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTMessage>
        implements TMessage {

    protected TMessageImpl(XmlContext xmlContext, EJaxbTMessage jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTMessage> getCompliantModelClass() {
        return EJaxbTMessage.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public Part[] getParts() {
        return createChildrenArray(getModelObject().getPart(),
                EJaxbTPart.class, ANY_QNAME, Part.class);
    }

    @Override
    public void addPart(Part part) {
        addToChildren(getModelObject().getPart(), part);
    }

    @Override
    public void removePart(Part part) {
        removeFromChildren(getModelObject().getPart(), part);
    }

    @Override
    public void clearParts() {
        clearChildren(getModelObject().getPart(), EJaxbTPart.class, ANY_QNAME);
    }

    @Override
    public Part getPartByName(String name) {
        return getChildByName(getParts(), name);
    }

}
