/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import java.util.IdentityHashMap;
import java.util.logging.Logger;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easyschema10.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.element.Include;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.type.TTypes;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTTypes;

class TTypesImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTTypes>
        implements TTypes {

    private static Logger LOG = Logger.getLogger(TImportImpl.class
            .getName());
    
    protected TTypesImpl(XmlContext xmlContext, EJaxbTTypes jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTTypes> getCompliantModelClass() {
        return EJaxbTTypes.class;
    }

    @Override
    protected XmlObject doCreateAdoptableChild(XmlObject parentAdopter,
            String publicId, String systemId,
            IdentityHashMap<XmlObject, Object> alreadyProcessed)  {
        if (publicId == null) {
        	if ((!(parentAdopter instanceof Include)) && (systemId != null)) {
        		LOG.warning(
        				String.format("No public id provided for system id '%s'.", systemId));
        	}
        }
        // Special case : if no system id is given 
        // check that adopted child is not in <types> children.
        if (systemId == null) {
            if (parentAdopter instanceof Import) {
                for (XmlObjectNode xon : getXmlObjectNaturalChildren()) {
                    if (!(xon instanceof Schema))
                        continue;
                    Schema schema = (Schema) xon;
                    if (publicId.equals(schema.getTargetNamespace())) {
                        return schema;
                    }
                }
            }
        }
        return super.doCreateAdoptableChild(parentAdopter, publicId, systemId,
                alreadyProcessed);
    }
}
