/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easywsdl11.api.type.TPart;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPart;

class TPartImpl extends AbstractTExtensibleAttributesDocumentedImpl<EJaxbTPart>
        implements TPart {

    protected TPartImpl(XmlContext xmlContext, EJaxbTPart jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTPart> getCompliantModelClass() {
        return EJaxbTPart.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasElement() {
        return getElement() != null;
    }

    @Override
    public QName getElement() {
        return getModelObject().getElement();
    }

    @Override
    public void setElement(QName qname) {
        getModelObject().setElement(qname);
    }

    @Override
    public boolean hasType() {
        return getType() != null;
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
    }

    @Override
    public Element findElement() {
        XmlObjectXPathEvaluator xpathEvaluator = getXmlContext()
                .createXPathEvaluator();
        QName elementQName = getElement();
        if (elementQName == null)
            return null;
        try {
            Element result = xpathEvaluator
                    .selectSingleXmlObjectNode(
                            getXmlObjectBaseRoot(),
                            String.format(
                                    "//xs:schema[@targetNamespace='%s']//xs:element[@name='%s']",
                                    elementQName.getNamespaceURI(),
                                    elementQName.getLocalPart()), Element.class);
            return result;
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
    }


}
