/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.element.Fault;
import com.ebmwebsourcing.easywsdl11.api.element.Input;
import com.ebmwebsourcing.easywsdl11.api.element.Output;
import com.ebmwebsourcing.easywsdl11.api.type.TOperation;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTFault;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTOperation;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTParam;

class TOperationImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTOperation>
        implements TOperation {

    protected TOperationImpl(XmlContext xmlContext, EJaxbTOperation jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTOperation> getCompliantModelClass() {
        return EJaxbTOperation.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasInput() {
        return getInput() != null;
    }

    @Override
    public Input getInput() {
        Input[] inputs = createChildrenArray(getModelObject().getRest(),
                EJaxbTParam.class, Input.QNAME, Input.class);
        assert inputs.length <= 1;
        return inputs.length == 1 ? inputs[0] : null;
    }

    @Override
    public void setInput(Input input) {
        clearChildren(getModelObject().getRest(), EJaxbTParam.class,
                Input.QNAME);
        if (input != null) {
            addToChildren(getModelObject().getRest(), input);
        }
    }

    @Override
    public boolean hasOutput() {
        return getOutput() != null;
    }

    @Override
    public Output getOutput() {
        Output[] outputs = createChildrenArray(getModelObject().getRest(),
                EJaxbTParam.class, Output.QNAME, Output.class);
        assert outputs.length <= 1;
        return outputs.length == 1 ? outputs[0] : null;
    }

    @Override
    public void setOutput(Output output) {
        clearChildren(getModelObject().getRest(), EJaxbTParam.class,
                Output.QNAME);
        if (output != null) {
            addToChildren(getModelObject().getRest(), output);
        }
    }

    @Override
    public Fault[] getFaults() {
        return createChildrenArray(getModelObject().getRest(),
                EJaxbTFault.class, Fault.QNAME, Fault.class);
    }

    @Override
    public void addFault(Fault fault) {
        addToChildren(getModelObject().getRest(), fault);
    }

    @Override
    public void removeFault(Fault fault) {
        removeFromChildren(getModelObject().getRest(), fault);
    }

    @Override
    public void clearFaults() {
        clearChildren(getModelObject().getRest(), EJaxbTFault.class,
                Fault.QNAME);
    }

    @Override
    public Fault getFaultByName(String name) {
        return getChildByName(getFaults(), name);
    }

}
