/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.type.TService;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPort;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTService;

class TServiceImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTService>
        implements TService {

    protected TServiceImpl(XmlContext xmlContext, EJaxbTService jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTService> getCompliantModelClass() {
        return EJaxbTService.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public Port[] getPorts() {
        return createChildrenArray(getModelObject().getPort(),
                EJaxbTPort.class, ANY_QNAME, Port.class);
    }

    @Override
    public void addPort(Port port) {
        addToChildren(getModelObject().getPort(), port);
    }

    @Override
    public void removePort(Port port) {
        removeFromChildren(getModelObject().getPort(), port);
    }

    @Override
    public void clearPorts() {
        clearChildren(getModelObject().getPort(), EJaxbTPort.class, ANY_QNAME);
    }

    @Override
    public Port getPortByName(String name) {
        return getChildByName(getPorts(), name);
    }
    
    @Override
    public QName inferQName() {
        String localPart = getName();
        if (localPart == null) return null;
        Definitions parentDefinitions = WsdlHelper.findParentDefinitions(this);
        if (parentDefinitions == null) return new QName(localPart);
        return new QName(parentDefinitions.getTargetNamespace(), localPart);
    }

}
