/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easywsdl11.api.Constants;

// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "easywsdl11-impl";
    }

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/easywsdl11";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "easywsdl11.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.xmlsoap.schemas.wsdl.ObjectFactory.class
                .getPackage();
    }

    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.WSDL11_NS_URI;
    }

    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.WSDL11_NS_PREFERRED_PREFIX;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();

        // elements
        factorableClasses.add(BindingImpl.class);
        factorableClasses.add(BindingOperationImpl.class);
        factorableClasses.add(BindingOperationFaultImpl.class);
        factorableClasses.add(BindingOperationInputImpl.class);
        factorableClasses.add(BindingOperationOutputImpl.class);
        factorableClasses.add(DefinitionsImpl.class);
        factorableClasses.add(DocumentationImpl.class);
        factorableClasses.add(FaultImpl.class);
        factorableClasses.add(ImportImpl.class);
        factorableClasses.add(InputImpl.class);
        factorableClasses.add(MessageImpl.class);
        factorableClasses.add(OperationImpl.class);
        factorableClasses.add(OutputImpl.class);
        factorableClasses.add(PartImpl.class);
        factorableClasses.add(PortImpl.class);
        factorableClasses.add(PortTypeImpl.class);
        factorableClasses.add(ServiceImpl.class);
        factorableClasses.add(TypesImpl.class);

        // types
        factorableClasses.add(TBindingImpl.class);
        factorableClasses.add(TBindingOperationFaultImpl.class);
        factorableClasses.add(TBindingOperationImpl.class);
        factorableClasses.add(TBindingOperationMessageImpl.class);
        factorableClasses.add(TDefinitionsImpl.class);
        factorableClasses.add(TDocumentationImpl.class);
        factorableClasses.add(TFaultImpl.class);
        factorableClasses.add(TImportImpl.class);
        factorableClasses.add(TMessageImpl.class);
        factorableClasses.add(TOperationImpl.class);
        factorableClasses.add(TParamImpl.class);
        factorableClasses.add(TPortImpl.class);
        factorableClasses.add(TPortTypeImpl.class);
        factorableClasses.add(TServiceImpl.class);
        factorableClasses.add(TTypesImpl.class);

        // anonymous types

        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }

    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject modelObject) throws InstantiationException,
            IllegalAccessException, InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, modelObject);
    }

}
