/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.soapbinding11.api;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperation;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.type.TBindingOperationMessage;
import com.ebmwebsourcing.soapbinding11.api.element.Address;

public final class SoapBindingHelper {
	
	private final static QName ADDRESS = new QName(Constants.SOAPBINDING11_NS_URI, "address");
	
	private SoapBindingHelper(){
	}
	
	public static boolean hasAddress(Port port) {
		return getAddress(port) != null;
	}
	
	public static Address getAddress(Port port) {
		return port.getFirstAnyXmlObject(Address.class);
	}
	
	public static void setAddress(Port port, Address newAddress) {
		Address existingAddress = port.getFirstAnyXmlObject(Address.class);
		if(existingAddress != null) {
			port.removeAnyXmlObject(existingAddress);
		}
		
		port.addAnyXmlObject(newAddress);
		
	}

	
	public static boolean hasSoapBinding(Binding binding) {
		return getSoapBinding(binding) != null;
	}
	
	public static com.ebmwebsourcing.soapbinding11.api.element.Binding getSoapBinding(Binding binding) {
		return binding.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Binding.class);
	}
	
	public static void setSoapBinding(Binding binding, com.ebmwebsourcing.soapbinding11.api.element.Binding newSoapBinding) {
		com.ebmwebsourcing.soapbinding11.api.element.Binding existingSoapBinding = binding.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Binding.class);
		if(existingSoapBinding != null) {
			binding.removeAnyXmlObject(existingSoapBinding);
		}
		binding.addAnyXmlObject(newSoapBinding);
		
	}


	public static boolean hasSoapOperation(BindingOperation operation) {
		return getSoapOperation(operation) != null;
	}
	
	public static com.ebmwebsourcing.soapbinding11.api.element.Operation getSoapOperation(BindingOperation operation) {
		return operation.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Operation.class);
	}
	
	public static void setSoapOperation(BindingOperation operation, com.ebmwebsourcing.soapbinding11.api.element.Operation newSoapOperation) {
		com.ebmwebsourcing.soapbinding11.api.element.Operation existingSoapOperation = operation.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Operation.class);
		if(existingSoapOperation != null) {
			operation.removeAnyXmlObject(existingSoapOperation);
		}
		operation.addAnyXmlObject(newSoapOperation);
	}
	
	
	public static boolean hasSoapBody(TBindingOperationMessage inputOrOutput) {
		return getSoapBody(inputOrOutput) != null;
	}
	
	public static boolean hasSoapHeader(TBindingOperationMessage inputOrOutput) {
		return getSoapHeader(inputOrOutput) != null;
	}
	public static com.ebmwebsourcing.soapbinding11.api.element.Body getSoapBody(TBindingOperationMessage inputOrOutput) {
		return inputOrOutput.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Body.class);
	}
	
	public static com.ebmwebsourcing.soapbinding11.api.element.Header getSoapHeader(TBindingOperationMessage inputOrOutput) {
		return inputOrOutput.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Header.class);
	}
	public static void setSoapBody(TBindingOperationMessage inputOrOutput, com.ebmwebsourcing.soapbinding11.api.element.Body newSoapBody) {
		com.ebmwebsourcing.soapbinding11.api.element.Body existingSoapBody = inputOrOutput.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Body.class);
		if(existingSoapBody != null) {
			inputOrOutput.removeAnyXmlObject(existingSoapBody);
		}
		inputOrOutput.addAnyXmlObject(newSoapBody);
	}
	public static void setSoapHeader(TBindingOperationMessage inputOrOutput, com.ebmwebsourcing.soapbinding11.api.element.Header newSoapHeader) {
		com.ebmwebsourcing.soapbinding11.api.element.Header existingSoapHeader = inputOrOutput.getFirstAnyXmlObject(com.ebmwebsourcing.soapbinding11.api.element.Header.class);
		if(existingSoapHeader != null) {
			inputOrOutput.removeAnyXmlObject(existingSoapHeader);
		}
		inputOrOutput.addAnyXmlObject(newSoapHeader);
	}
}
