package com.ebmwebsourcing.soapbinding11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.soapbinding11.api.type.TOperation;
import com.ebmwebsourcing.soapbinding11.api.type.TStyleChoice;

import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTOperation;
import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTStyleChoice;

class TOperationImpl extends AbstractJaxbXmlObjectImpl<EJaxbTOperation>
        implements TOperation {

    protected TOperationImpl(XmlContext xmlContext, EJaxbTOperation jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTOperation> getCompliantModelClass() {
        return EJaxbTOperation.class;
    }

	@Override
	public boolean hasRequired() {
		return this.getModelObject().isSetRequired();
	}

	@Override
	public boolean getRequired() {
		return this.getModelObject().isRequired();
	}

	@Override
	public void setRequired(boolean required) {
		this.getModelObject().setRequired(required);
	}

	@Override
	public boolean hasSoapAction() {
		return this.getSoapAction() != null;
	}

	@Override
	public String getSoapAction() {
		return this.getModelObject().getSoapAction();
	}

	@Override
	public void setSoapAction(String soapAction) {
		this.getModelObject().setSoapAction(soapAction);
	}

	@Override
	public TStyleChoice getStyle() {
		if (getModelObject().getStyle() == null)
            return null;
        return TStyleChoice.valueOf(getModelObject().getStyle().toString().toUpperCase());
	}

	@Override
	public void setStyle(TStyleChoice style) {
		if (style == null) {
            getModelObject().setStyle(null);
        } else if (style.equals(TStyleChoice.DOCUMENT)) {
            getModelObject().setStyle(EJaxbTStyleChoice.DOCUMENT);
        } else {
            getModelObject().setStyle(EJaxbTStyleChoice.RPC);
        }
	}

	@Override
	public boolean hasStyle() {
		return getModelObject().getStyle() != null;
	}


}
