package com.ebmwebsourcing.soapbinding11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.soapbinding11.api.type.TAddress;

import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTAddress;

class TAddressImpl extends AbstractJaxbXmlObjectImpl<EJaxbTAddress>
        implements TAddress {

    protected TAddressImpl(XmlContext xmlContext, EJaxbTAddress jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTAddress> getCompliantModelClass() {
        return EJaxbTAddress.class;
    }


	@Override
	public boolean hasLocation() {
		return getModelObject().getLocation() != null;
	}

	@Override
	public String getLocation() {
		return getModelObject().getLocation();
	}

	@Override
	public void setLocation(String location) {
		getModelObject().setLocation(location);
	}


}
