/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.soapbinding11.impl;

import java.util.Arrays;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;


import com.ebmwebsourcing.soapbinding11.api.element.HeaderFault;
import com.ebmwebsourcing.soapbinding11.api.type.THeader;
import com.ebmwebsourcing.soapbinding11.api.type.TUseChoice;


import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTHeader;
import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbUseChoice;

class THeaderImpl extends AbstractJaxbXmlObjectImpl<EJaxbTHeader>
implements THeader {

	protected THeaderImpl(XmlContext xmlContext, EJaxbTHeader jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public boolean hasRequired() {
		return this.getModelObject().isSetRequired();
	}

	@Override
	public boolean getRequired() {
		return this.getModelObject().isRequired();
	}

	@Override
	public void setRequired(boolean required) {
		this.getModelObject().setRequired(required);
	}

	@Override
	public boolean hasMessage() {
		return this.getModelObject().isSetMessage();
	}

	@Override
	public QName getMessage() {
		return this.getModelObject().getMessage(); 
	}

	@Override
	public void setMessage(QName message) {
		this.getModelObject().setMessage(message);

	}

	@Override
	public boolean hasPart() {
		return this.getModelObject().isSetPart();
	}

	@Override
	public String getPart() {
		return this.getModelObject().getPart();
	}

	@Override
	public void setPart(String part) {
		this.getModelObject().setPart(part);
	}

	@Override
	public TUseChoice getUse() {
		if(this.getModelObject().getUse() == null) return null;
		return TUseChoice.valueOf(this.getModelObject().getUse().toString());
	}

	@Override
	public void setUse(TUseChoice value) {
		if(value == null) {
			this.getModelObject().setUse(null);
		}else if(value.equals(TUseChoice.ENCODED)){
			this.getModelObject().setUse(EJaxbUseChoice.ENCODED);
		}else if(value.equals(TUseChoice.LITERAL)){
			this.getModelObject().setUse(EJaxbUseChoice.LITERAL);
		}
	}
	
	@Override
	public boolean hasUse() {
	    return this.getModelObject().isSetUse();
	}

	@Override
	public boolean hasEncodingStyle() {
		return this.getModelObject().isSetEncodingStyle();

	}

	@Override
	public String[] getEncodingStyle() {
		return this.getModelObject().getEncodingStyle().toArray(new String[this.getModelObject().getEncodingStyle().size()]);
	}

	@Override
	public void setEncodingStyle(String[] encodingStyle) {
		this.getModelObject().getEncodingStyle().clear();
		this.getModelObject().getEncodingStyle().addAll(Arrays.asList(encodingStyle));

	}

	@Override
	public boolean hasNamespace() {
		return this.getModelObject().isSetNamespace();
	}

	@Override
	public String getNamespace() {
		return this.getModelObject().getNamespace();
	}

	@Override
	public void setNamespace(String namespace) {
		this.getModelObject().setNamespace(namespace);

	}

	@Override
	public HeaderFault[] getHeaderFaults() {
		return this.getModelObject().getHeaderfault().toArray(new HeaderFault[this.getModelObject().getHeaderfault().size()]);
	}

	@Override
	public void addHeaderFault(HeaderFault headerFault) {
		addToChildren(this.getModelObject().getHeaderfault(), headerFault);
	}

	@Override
	public void removeHeaderFault(HeaderFault headerFault) {
		removeFromChildren(this.getModelObject().getHeaderfault(), headerFault);
	}

	@Override
	public void clearHeaderFaults() {
		clearChildren(this.getModelObject().getHeaderfault(), null, null);
	}

	@Override
	protected Class<? extends EJaxbTHeader> getCompliantModelClass() {
		return EJaxbTHeader.class;
	}

}
