/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.soapbinding11.impl;

import java.util.Arrays;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.soapbinding11.api.type.TBody;
import com.ebmwebsourcing.soapbinding11.api.type.TUseChoice;

import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTBody;
import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbUseChoice;

class TBodyImpl extends AbstractJaxbXmlObjectImpl<EJaxbTBody>
        implements TBody {

    protected TBodyImpl(XmlContext xmlContext, EJaxbTBody jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTBody> getCompliantModelClass() {
        return EJaxbTBody.class;
    }

	@Override
	public boolean hasEncodingStyle() {
		return this.getModelObject().isSetEncodingStyle();
	}

	@Override
	public String[] getEncodingStyle() {
		return this.getModelObject().getEncodingStyle().toArray(new String[this.getModelObject().getEncodingStyle().size()]);
	}

	@Override
	public void setEncodingStyle(String[] encodingStyle) {
		this.getModelObject().getEncodingStyle().clear();
		this.getModelObject().getEncodingStyle().addAll(Arrays.asList(encodingStyle));
	}

    @Override
    public TUseChoice getUse() {
        TUseChoice res = null;
        if (this.getModelObject().isSetUse()) {
            switch (this.getModelObject().getUse()) {
                case ENCODED:
                    res = TUseChoice.ENCODED;
                    break;
                case LITERAL:
                    res = TUseChoice.LITERAL;
                    break;
            }
        }
        return res;
    }

    @Override
    public void setUse(TUseChoice arg0) {
        if (arg0 != null) {
            switch (arg0) {
                case ENCODED:
                    this.getModelObject().setUse(EJaxbUseChoice.ENCODED);
                    break;
                case LITERAL:
                    this.getModelObject().setUse(EJaxbUseChoice.LITERAL);
                    break;
            }
        } else {
            this.getModelObject().setUse(null);
        }
    }

    @Override
    public boolean hasUse() {
        return this.getModelObject().isSetUse();
    }

	@Override
	public String getNamespace() {
		return this.getModelObject().getNamespace();
	}

	@Override
	public boolean hasNamespace() {
		return this.getNamespace() != null;
	}

	@Override
	public void setNamespace(String arg0) {
		this.getModelObject().setNamespace(arg0);
	}

	@Override
	public boolean hasParts() {
		return this.getParts() != null;
	}

	@Override
	public String[] getParts() {
		return this.getModelObject().getParts().toArray(new String[this.getModelObject().getParts().size()]);
	}

	@Override
	public void setParts(String[] parts) {
		this.getModelObject().getParts().clear();
		this.getModelObject().getParts().addAll(Arrays.asList(parts));
	}




}
