package com.ebmwebsourcing.escad10.protocol.soapnotif.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.escad10.protocol.soapnotif.api.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "soapnotif-impl";
    }    
    
    @Override
    public String getOriginatingSchemaDir() {
        return "schema/escad10/extensions/protocols";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "soap-notification.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.protocol.definition.alerting.common.petalslink.com.soap_notification._1.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.ESCAD_BINDING_SOAP_NOTIF_NS_URI;
    }
    
    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.ESCAD_BINDING_SOAP_NOTIF_NS_PREFERRED_PREFIX;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        factorableClasses.add(BindingImpl.class);
        factorableClasses.add(BindingTypeImpl.class);

        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObject);
    }

}
