package com.ebmwebsourcing.escad10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.escad10.api.element.Protocol;
import com.ebmwebsourcing.escad10.api.type.FormatType;
import com.ebmwebsourcing.escad10.api.type.PartnerType;
import com.ebmwebsourcing.escad10.api.type.ToType;

import easybox.definition.alerting.common.petalslink.com._1.EJaxbFormatType;
import easybox.definition.alerting.common.petalslink.com._1.EJaxbPartnerType;
import easybox.definition.alerting.common.petalslink.com._1.EJaxbProtocolType;
import easybox.definition.alerting.common.petalslink.com._1.EJaxbToType;

class ToTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbToType> implements
		ToType {

	protected ToTypeImpl(XmlContext xmlContext, EJaxbToType jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbToType> getCompliantModelClass() {
		return EJaxbToType.class;
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().getName() != null;
	}

	@Override
	public void setName(String name) {
		this.getModelObject().setName(name);
	}

	@Override
	public String getFirstname() {
		return this.getModelObject().getFirstname();
	}

	@Override
	public void setFirstname(String value) {
		this.getModelObject().setFirstname(value);
	}

	@Override
	public boolean hasFirstname() {
		return this.getModelObject().getFirstname() != null;
	}

	@Override
	public String getLastname() {
		return this.getModelObject().getLastname();
	}

	@Override
	public void setLastname(String value) {
		this.getModelObject().setLastname(value);
	}

	@Override
	public boolean hasLastname() {
		return this.getModelObject().getLastname() != null;
	}

	@Override
	public String getId() {
		return this.getModelObject().getId();
	}

	@Override
	public void setId(String id) {
		this.getModelObject().setId(id);
	}

	@Override
	public Protocol[] getProtocols() {
		return createChildrenArray(getModelObject().getProtocol(),
				EJaxbProtocolType.class, ANY_QNAME, Protocol.class);
	}

	@Override
	public void addProtocol(Protocol protocol) {
		addToChildren(getModelObject().getProtocol(), protocol);
	}

	@Override
	public void removeProtocol(Protocol protocol) {
		removeFromChildren(getModelObject().getProtocol(), protocol);
	}

	@Override
	public void clearProtocols() {
		clearChildren(getModelObject().getProtocol(), EJaxbProtocolType.class,
				ANY_QNAME);
	}

	@Override
	public Protocol getProtocolByName(String name) {
		return getChildByName(getProtocols(), name);
	}

	@Override
	public PartnerType getPartner() {
		if (getModelObject().getPartner() == null)
			return null;
		return PartnerType.valueOf(getModelObject().getPartner().toString()
				.toUpperCase());
	}

	@Override
	public void setPartner(PartnerType pt) {
		if (pt == null) {
			getModelObject().setPartner(null);
		} else if (pt.equals(PartnerType.CLIENT)) {
			getModelObject().setPartner(EJaxbPartnerType.CLIENT);
		} else if (pt.equals(PartnerType.PROVIDER)) {
			getModelObject().setPartner(EJaxbPartnerType.PROVIDER);
		} else {
			getModelObject().setPartner(EJaxbPartnerType.OTHERS);
		}
	}

	@Override
	public boolean hasPartner() {
		return this.getPartner() != null;
	}

	@Override
	public FormatType getFormat() {
		if (getModelObject().getFormat() == null)
			return null;
		return FormatType.valueOf(getModelObject().getFormat().toString()
				.toUpperCase());
	}

	@Override
	public void setFormat(FormatType f) {
		if (f == null) {
			getModelObject().setFormat(null);
		} else if (f.equals(FormatType.CAP)) {
			getModelObject().setFormat(EJaxbFormatType.CAP);
		} else {
			getModelObject().setFormat(EJaxbFormatType.RAW);
		}
	}

	@Override
	public boolean hasFormat() {
		return this.getFormat() != null;
	}

}
